/*
 * Decompiled with CFR 0.152.
 */
package timber.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import timber.Main;

@Mod.EventBusSubscriber
public class Config {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        Main.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Main.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        Main.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Config.loadConfig(clientSpec, FMLPaths.CONFIGDIR.get().resolve("timber-client.toml"));
        Config.loadConfig(serverSpec, FMLPaths.CONFIGDIR.get().resolve("timber.toml"));
        Main.LOGGER.debug("Loaded {} config file {}", (Object)"timber", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        Config.loadConfig(clientSpec, FMLPaths.CONFIGDIR.get().resolve("timber-client.toml"));
        Config.loadConfig(serverSpec, FMLPaths.CONFIGDIR.get().resolve("timber.toml"));
        Main.LOGGER.fatal(Logging.CORE, "{} config just got changed on the file system!", (Object)"timber");
    }

    static {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue activateTimberMod;
        public final ForgeConfigSpec.BooleanValue visualIndicator;
        public final ForgeConfigSpec.BooleanValue reverseControl;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings").push("client");
            this.activateTimberMod = builder.comment(" Timber Mod will disable itself if this value is set to false. Default: true.").define("activate_timber_mod", true);
            this.visualIndicator = builder.comment(" Shows a text at your crosshair to inform you that you have Timber activated. Default: true.").define("visual_indicator", true);
            this.reverseControl = builder.comment(" Reverses the control of sneaking, if false then sneaking and chopping will disable the Timber Mod, if true then it's in reverse. Default: false.").define("reverse_control", false);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue dropsInCreativeMode;
        public final ForgeConfigSpec.BooleanValue damageAxe;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.dropsInCreativeMode = builder.comment(" Timber Mod will drop items in creative mode aswell, true to enable, false to disable. Default: false.").define("drops_in_creative_mode", false);
            this.damageAxe = builder.comment(" Will damage the axe with the amount of logs chopped, true to enable, false to disable. Default: true.").define("damage_axe", true);
            builder.pop();
        }
    }
}

