/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.DeathManager;
import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerProvider;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class MessageShowCorpseInventory
implements Message {
    private UUID playerUUID;
    private UUID deathID;

    public MessageShowCorpseInventory() {
    }

    public MessageShowCorpseInventory(UUID playerUUID, UUID deathID) {
        this.playerUUID = playerUUID;
        this.deathID = deathID;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        PlayerEntity player = context.getSender().field_70170_p.func_217371_b(this.playerUUID);
        if (player instanceof ServerPlayerEntity) {
            MessageShowCorpseInventory.openCorpseGUI(context.getSender(), (ServerPlayerEntity)player, this.deathID);
        }
    }

    public static void openCorpseGUI(ServerPlayerEntity playerToShow, ServerPlayerEntity player, UUID uuid) {
        Death death = DeathManager.getDeath(player, uuid);
        if (death == null) {
            return;
        }
        CorpseEntity corpse = CorpseEntity.createFromDeath((PlayerEntity)playerToShow, death);
        NetworkHooks.openGui((ServerPlayerEntity)playerToShow, (INamedContainerProvider)new CorpseContainerProvider(corpse, playerToShow.field_71075_bZ.field_75098_d, true), packetBuffer -> {
            packetBuffer.writeBoolean(true);
            packetBuffer.func_150786_a(death.toNBT());
        });
    }

    public MessageShowCorpseInventory fromBytes(PacketBuffer buf) {
        this.playerUUID = new UUID(buf.readLong(), buf.readLong());
        this.deathID = new UUID(buf.readLong(), buf.readLong());
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.playerUUID.getMostSignificantBits());
        buf.writeLong(this.playerUUID.getLeastSignificantBits());
        buf.writeLong(this.deathID.getMostSignificantBits());
        buf.writeLong(this.deathID.getLeastSignificantBits());
    }
}

