/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.integration.waila;

import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.DeathManager;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HUDHandlerCorpse
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation CONFIG_SHOW_REGISTRY = new ResourceLocation("waila", "show_registry");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    static final HUDHandlerCorpse INSTANCE = new HUDHandlerCorpse();

    public void appendHead(List<ITextComponent> t, IEntityAccessor accessor, IPluginConfig config) {
        ITaggableList tooltip = (ITaggableList)t;
        tooltip.setTag((Object)OBJECT_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getEntityName(), accessor.getEntity().func_145748_c_().getString())));
        if (config.get(CONFIG_SHOW_REGISTRY)) {
            tooltip.setTag((Object)REGISTRY_NAME_TAG, (Object)new StringTextComponent(accessor.getEntity().func_200600_R().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!(accessor.getEntity() instanceof CorpseEntity)) {
            return;
        }
        CompoundNBT data = accessor.getServerData();
        if (data.func_74764_b("death")) {
            Death death = Death.fromNBT(data.func_74775_l("death"));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.corpse.death_date", new Object[]{DeathHistoryScreen.getDate(death.getTimestamp())}));
        }
        if (data.func_74764_b("item_count")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.corpse.item_count", new Object[]{data.func_74762_e("item_count")}));
        }
    }

    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getModName(), ModIdentification.getModInfo((Entity)accessor.getEntity()).getName())));
    }

    public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, Entity entity) {
        CorpseEntity corpse = (CorpseEntity)entity;
        UUID uuid = corpse.getDeathUUID();
        if (uuid == null) {
            return;
        }
        Death death = DeathManager.getDeath(serverPlayerEntity, uuid);
        compoundNBT.func_218657_a("death", (INBT)death.toNBT(false));
        compoundNBT.func_74768_a("item_count", HUDHandlerCorpse.getStackCount(corpse));
    }

    public static int getStackCount(IInventory inventory) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            ++count;
        }
        return count;
    }
}

