/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.gui.DeathHistoryContainer;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class DeathHistoryScreen
extends ScreenBase<Container> {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/gui_death_history.png");
    private Button previous;
    private Button next;
    private List<Death> deaths;
    private int index;
    private int hSplit;

    public DeathHistoryScreen(List<Death> deaths) {
        super(DEATH_HISTORY_GUI_TEXTURE, new DeathHistoryContainer(), null, (ITextComponent)new TranslationTextComponent("gui.death_history.corpse.title"));
        this.deaths = deaths;
        this.index = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.hSplit = this.field_146999_f / 2;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, (ITextComponent)new TranslationTextComponent("button.corpse.previous"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + (this.field_146999_f - buttonWidth) / 2, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, (ITextComponent)new TranslationTextComponent("button.corpse.show_items"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShowCorpseInventory(this.getCurrentDeath().getPlayerUUID(), this.getCurrentDeath().getId()))));
        this.next = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - buttonWidth - padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, (ITextComponent)new TranslationTextComponent("button.corpse.next"), button -> {
            ++this.index;
            if (this.index >= this.deaths.size()) {
                this.index = this.deaths.size() - 1;
            }
        }));
    }

    public boolean func_231044_a_(double x, double y, int clickType) {
        if (x >= (double)(this.field_147003_i + 7) && x <= (double)(this.field_147003_i + this.hSplit) && y >= (double)(this.field_147009_r + 70)) {
            this.field_230712_o_.getClass();
            if (y <= (double)(this.field_147009_r + 100 + 9)) {
                BlockPos pos = this.getCurrentDeath().getBlockPos();
                IFormattableTextComponent teleport = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})).func_240700_a_(style -> style.func_240723_c_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip"))));
                this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("chat.corpse.teleport_death_location", new Object[]{teleport}), Util.field_240973_b_);
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.field_230706_i_.func_147108_a(null);
            }
        }
        return super.func_231044_a_(x, y, clickType);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        Death death = this.getCurrentDeath();
        String title = new TranslationTextComponent("gui.corpse.death_history.title").getString();
        int titleWidth = this.field_230712_o_.func_78256_a(title);
        this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.BLACK + title, (float)((this.field_146999_f - titleWidth) / 2), 7.0f, 0);
        String date = DeathHistoryScreen.getDate(death.getTimestamp()).getString();
        int dateWidth = this.field_230712_o_.func_78256_a(date);
        this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + date, (float)((this.field_146999_f - dateWidth) / 2), 20.0f, 0);
        String textName = new TranslationTextComponent("gui.corpse.death_history.name").getString() + ":";
        this.drawLeft(matrixStack, TextFormatting.DARK_GRAY + textName, 40);
        String name = death.getPlayerName();
        this.drawRight(matrixStack, TextFormatting.GRAY + name, 40);
        String textDimension = new TranslationTextComponent("gui.corpse.death_history.dimension").getString() + ":";
        this.drawLeft(matrixStack, TextFormatting.DARK_GRAY + textDimension, 55);
        String dimension = death.getDimension().split(":")[1];
        this.drawRight(matrixStack, TextFormatting.GRAY + dimension, 55);
        String textLocation = new TranslationTextComponent("gui.corpse.death_history.location").getString() + ":";
        this.drawLeft(matrixStack, TextFormatting.DARK_GRAY + textLocation, 70);
        this.drawRight(matrixStack, TextFormatting.GRAY + "" + Math.round(death.getPosX()) + " X", 70);
        this.drawRight(matrixStack, TextFormatting.GRAY + "" + Math.round(death.getPosY()) + " Y", 85);
        this.drawRight(matrixStack, TextFormatting.GRAY + "" + Math.round(death.getPosZ()) + " Z", 100);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RemoteClientPlayerEntity player = new RemoteClientPlayerEntity(this.field_230706_i_.field_71441_e, new GameProfile(death.getPlayerUUID(), death.getPlayerName())){

            public EntitySize func_213305_a(Pose pose) {
                return new EntitySize(super.func_213305_a((Pose)pose).field_220315_a, Float.MAX_VALUE, true);
            }
        };
        player.func_213323_x_();
        InventoryScreen.func_228187_a_((int)((int)((double)this.field_146999_f * 0.75)), (int)(this.field_147000_g / 2 + 30), (int)40, (float)((int)((double)this.field_147003_i + (double)this.field_146999_f * 0.75) - mouseX), (float)(this.field_147000_g / 2 - mouseY), (LivingEntity)player);
        if (mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + this.hSplit && mouseY >= this.field_147009_r + 70) {
            this.field_230712_o_.getClass();
            if (mouseY <= this.field_147009_r + 100 + 9) {
                this.func_238654_b_(matrixStack, Collections.singletonList(new TranslationTextComponent("tooltip.corpse.teleport")), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        }
    }

    public static ITextComponent getDate(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(new TranslationTextComponent("gui.corpse.death_history.date_format").getString());
        return new StringTextComponent(dateFormat.format(new Date(timestamp)));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.previous.field_230693_o_ = this.index > 0;
        this.next.field_230693_o_ = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(MatrixStack matrixStack, String string, int height) {
        int offset;
        int offsetLeft = offset = 7;
        this.field_230712_o_.func_238421_b_(matrixStack, string, (float)offsetLeft, (float)height, 0);
    }

    public void drawRight(MatrixStack matrixStack, String string, int height) {
        int strWidth = this.field_230712_o_.func_78256_a(string);
        this.field_230712_o_.func_238421_b_(matrixStack, string, (float)(this.hSplit - strWidth), (float)height, 0);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

