/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.block.BlockFluidPump;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.tileentity.FluidPipeTileEntity;
import com.mrcrayfish.vehicle.util.FluidUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPumpTileEntity
extends FluidPipeTileEntity {
    private PowerMode powerMode;

    public FluidPumpTileEntity() {
        super((TileEntityType)ModTileEntities.FLUID_PUMP.get(), (Integer)Config.SERVER.pumpCapacity.get());
        this.transferAmount = (Integer)Config.SERVER.pumpTransferAmount.get();
        this.powerMode = PowerMode.REQUIRES_SIGNAL_ON;
    }

    public void cyclePowerMode(PlayerEntity player) {
        this.powerMode = PowerMode.values()[(this.powerMode.ordinal() + 1) % PowerMode.values().length];
        this.powerMode.notifyPlayerOfChange(player);
        this.syncFluidToClient();
    }

    @Override
    public void func_73660_a() {
        if (this.powerMode != PowerMode.ALWAYS_ACTIVE && this.field_145850_b.func_175640_z(this.field_174879_c) != (this.powerMode == PowerMode.REQUIRES_SIGNAL_ON)) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Direction facing = (Direction)state.func_177229_b((Property)BlockFluidPump.DIRECTION);
        ArrayList<IFluidHandler> fluidHandlers = new ArrayList<IFluidHandler>();
        for (Direction face : Direction.values()) {
            IFluidHandler handler;
            if (this.getDisabledConnections()[face.func_176745_a()] || !((Boolean)state.func_177229_b((Property)BlockFluidPump.CONNECTED_PIPES[face.func_176745_a()])).booleanValue() || (handler = this.getConnectedFluidHandler(face)) == null) continue;
            fluidHandlers.add(handler);
        }
        int outputCount = fluidHandlers.size();
        if (outputCount == 0) {
            return;
        }
        IFluidHandler handler = this.getConnectedFluidHandler(facing.func_176734_d());
        if (handler != null) {
            FluidUtils.transferFluid(handler, (IFluidHandler)this.tank, this.transferAmount);
        }
        if (outputCount == 1) {
            FluidUtils.transferFluid((IFluidHandler)this.tank, (IFluidHandler)fluidHandlers.get(0), this.transferAmount);
            return;
        }
        int remainder = Math.min(this.tank.getFluidAmount(), this.transferAmount * outputCount);
        int amount = remainder / outputCount;
        if (amount > 0) {
            fluidHandlers.removeIf(iFluidHandler -> FluidUtils.transferFluid((IFluidHandler)this.tank, iFluidHandler, amount) < amount);
        }
        remainder %= outputCount;
        if (fluidHandlers.size() == 1) {
            FluidUtils.transferFluid((IFluidHandler)this.tank, (IFluidHandler)fluidHandlers.get(0), remainder);
        }
        for (int i = 0; i < remainder && !fluidHandlers.isEmpty(); ++i) {
            int index = this.field_145850_b.field_73012_v.nextInt(fluidHandlers.size());
            int filled = FluidUtils.transferFluid((IFluidHandler)this.tank, (IFluidHandler)fluidHandlers.get(index), 1);
            remainder -= filled;
            if (filled != 0) continue;
            fluidHandlers.remove(index);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("PowerMode", 3)) {
            this.powerMode = PowerMode.fromOrdinal(compound.func_74762_e("PowerMode"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("PowerMode", this.powerMode.ordinal());
        return super.func_189515_b(compound);
    }

    public static enum PowerMode {
        ALWAYS_ACTIVE("always"),
        REQUIRES_SIGNAL_ON("on"),
        REQUIRES_SIGNAL_OFF("off");

        private static final String LANG_KEY_CHAT_PREFIX = "vehicle.chat.pump.power";
        private String langKeyChat;

        private PowerMode(String langKeyChat) {
            this.langKeyChat = langKeyChat;
        }

        public void notifyPlayerOfChange(PlayerEntity player) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(LANG_KEY_CHAT_PREFIX, new Object[]{new TranslationTextComponent("vehicle.chat.pump.power." + this.langKeyChat)}), true);
        }

        @Nullable
        public static PowerMode fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= PowerMode.values().length) {
                return null;
            }
            return PowerMode.values()[ordinal];
        }
    }
}

