/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageTurnAngle
implements IMessage<MessageTurnAngle> {
    private float angle;

    public MessageTurnAngle() {
    }

    public MessageTurnAngle(float angle) {
        this.angle = angle;
    }

    @Override
    public void encode(MessageTurnAngle message, PacketBuffer buffer) {
        buffer.writeFloat(message.angle);
    }

    @Override
    public MessageTurnAngle decode(PacketBuffer buffer) {
        return new MessageTurnAngle(buffer.readFloat());
    }

    @Override
    public void handle(MessageTurnAngle message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Entity riding;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (riding = player.func_184187_bx()) instanceof PoweredVehicleEntity) {
                ((PoweredVehicleEntity)riding).setTargetTurnAngle(message.angle);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

