/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.network.message.IMessage;
import com.mrcrayfish.vehicle.util.CommonUtils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageInteractKey
implements IMessage<MessageInteractKey> {
    private int entityId;

    public MessageInteractKey() {
    }

    public MessageInteractKey(Entity targetEntity) {
        this.entityId = targetEntity.func_145782_y();
    }

    private MessageInteractKey(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public void encode(MessageInteractKey message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
    }

    @Override
    public MessageInteractKey decode(PacketBuffer buffer) {
        return new MessageInteractKey(buffer.readInt());
    }

    @Override
    public void handle(MessageInteractKey message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            PoweredVehicleEntity poweredVehicle;
            Entity targetEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (targetEntity = player.field_70170_p.func_73045_a(message.entityId)) instanceof PoweredVehicleEntity && (poweredVehicle = (PoweredVehicleEntity)targetEntity).isKeyNeeded()) {
                ItemStack stack = player.func_184614_ca();
                if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.WRENCH.get()) {
                    if (poweredVehicle.isOwner((PlayerEntity)player)) {
                        poweredVehicle.ejectKey();
                        poweredVehicle.setKeyNeeded(false);
                        CommonUtils.sendInfoMessage((PlayerEntity)player, "vehicle.status.key_removed");
                    } else {
                        CommonUtils.sendInfoMessage((PlayerEntity)player, "vehicle.status.invalid_owner");
                    }
                    return;
                }
                if (poweredVehicle.getKeyStack().func_190926_b()) {
                    if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.KEY.get()) {
                        UUID keyUuid = CommonUtils.getOrCreateStackTag(stack).func_186857_a("VehicleId");
                        if (poweredVehicle.func_110124_au().equals(keyUuid)) {
                            poweredVehicle.setKeyStack(stack.func_77946_l());
                            player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                        } else {
                            CommonUtils.sendInfoMessage((PlayerEntity)player, "vehicle.status.key_invalid");
                        }
                    }
                } else {
                    poweredVehicle.ejectKey();
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

