/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageFlaps;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class PlaneEntity
extends PoweredVehicleEntity {
    private static final DataParameter<Integer> FLAP_DIRECTION = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> LIFT = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private float lift;
    public float prevBodyRotationX;
    public float prevBodyRotationY;
    public float prevBodyRotationZ;
    public float bodyRotationX;
    public float bodyRotationY;
    public float bodyRotationZ;

    protected PlaneEntity(EntityType<?> entityType, World worldIn) {
        super(entityType, worldIn);
        this.setAccelerationSpeed(0.5f);
        this.setMaxSpeed(25.0f);
        this.setTurnSensitivity(5);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLAP_DIRECTION, (Object)FlapDirection.NONE.ordinal());
        this.field_70180_af.func_187214_a(LIFT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void updateVehicleMotion() {
        float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
        float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
        this.updateLift();
        this.vehicleMotionX = -this.currentSpeed * f1;
        this.vehicleMotionZ = this.currentSpeed * f2;
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)this.lift - 0.05, 0.0));
    }

    @Override
    public void onClientUpdate() {
        super.onClientUpdate();
        this.prevBodyRotationX = this.bodyRotationX;
        this.prevBodyRotationY = this.bodyRotationY;
        this.prevBodyRotationZ = this.bodyRotationZ;
        LivingEntity entity = (LivingEntity)this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            FlapDirection flapDirection = VehicleMod.PROXY.getFlapDirection();
            if (this.getFlapDirection() != flapDirection) {
                this.setFlapDirection(flapDirection);
                PacketHandler.instance.sendToServer((Object)new MessageFlaps(flapDirection));
            }
        }
        if (this.isFlying()) {
            this.bodyRotationX = (float)Math.toDegrees(Math.atan2(this.func_213322_ci().func_82617_b(), this.currentSpeed / 20.0f));
            this.bodyRotationZ = this.turnAngle / (float)this.getMaxTurnAngle() * 20.0f;
        } else {
            this.bodyRotationX *= 0.5f;
            this.bodyRotationZ *= 0.5f;
        }
    }

    @Override
    protected void updateSpeed() {
        this.lift = 0.0f;
        this.currentSpeed = this.getSpeed();
        if (this.func_184179_bs() != null) {
            PoweredVehicleEntity.AccelerationDirection acceleration = this.getAcceleration();
            if (this.canDrive() && acceleration == PoweredVehicleEntity.AccelerationDirection.FORWARD) {
                if (this.func_213322_ci().func_82617_b() < 0.0) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.95, 1.0));
                }
                EngineTier engineTier = this.getEngineTier();
                float accelerationSpeed = this.getModifiedAccelerationSpeed() * engineTier.getAccelerationMultiplier();
                if (this.currentSpeed < this.getActualMaxSpeed()) {
                    this.currentSpeed += accelerationSpeed;
                }
                this.lift = 0.051f * (Math.min(this.currentSpeed, 15.0f) / 15.0f);
            } else if (acceleration == PoweredVehicleEntity.AccelerationDirection.REVERSE) {
                this.currentSpeed = this.isFlying() ? (this.currentSpeed *= 0.95f) : (this.currentSpeed *= 0.9f);
            }
            if (acceleration != PoweredVehicleEntity.AccelerationDirection.FORWARD) {
                this.currentSpeed = this.isFlying() ? (this.currentSpeed *= 0.995f) : (this.currentSpeed *= 0.98f);
                this.lift = 0.04f * (Math.min(this.currentSpeed, 15.0f) / 15.0f);
            }
        } else {
            this.currentSpeed = this.isFlying() ? (this.currentSpeed *= 0.98f) : (this.currentSpeed *= 0.85f);
        }
    }

    @Override
    protected void updateTurning() {
        PoweredVehicleEntity.TurnDirection direction = this.getTurnDirection();
        if (this.func_184179_bs() != null && direction != PoweredVehicleEntity.TurnDirection.FORWARD) {
            this.turnAngle += (float)(direction.dir * this.getTurnSensitivity());
            if (Math.abs(this.turnAngle) > (float)this.getMaxTurnAngle()) {
                this.turnAngle = this.getMaxTurnAngle() * direction.dir;
            }
        } else {
            this.turnAngle = (float)((double)this.turnAngle * 0.95);
        }
        this.wheelAngle = this.isFlying() ? this.turnAngle * Math.max(0.25f, 1.0f - Math.abs(Math.min(this.currentSpeed, 30.0f) / 30.0f)) : this.turnAngle * Math.abs(Math.min(this.currentSpeed, 30.0f) / 30.0f);
        this.deltaYaw = this.wheelAngle;
        this.deltaYaw = this.isFlying() ? (float)((double)this.deltaYaw * 0.5) : (float)((double)this.deltaYaw * (0.5 * (0.5 + 0.5 * (double)(1.0f - Math.min(this.currentSpeed, 15.0f) / 15.0f))));
    }

    public void updateLift() {
        FlapDirection flapDirection = this.getFlapDirection();
        if (flapDirection == FlapDirection.UP) {
            this.lift += 0.04f * (Math.min(Math.max(this.currentSpeed - 5.0f, 0.0f), 15.0f) / 15.0f);
        } else if (flapDirection == FlapDirection.DOWN) {
            this.lift -= 0.06f * (Math.min(this.currentSpeed, 15.0f) / 15.0f);
        }
        this.setLift(this.lift);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("FlapDirection", this.getFlapDirection().ordinal());
        compound.func_74776_a("Lift", this.getLift());
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("FlapDirection", 3)) {
            this.setFlapDirection(FlapDirection.values()[compound.func_74762_e("FlapDirection")]);
        }
        if (compound.func_150297_b("Lift", 5)) {
            this.setLift(compound.func_74760_g("Lift"));
        }
    }

    public void setFlapDirection(FlapDirection flapDirection) {
        this.field_70180_af.func_187227_b(FLAP_DIRECTION, (Object)flapDirection.ordinal());
    }

    public FlapDirection getFlapDirection() {
        return FlapDirection.values()[(Integer)this.field_70180_af.func_187225_a(FLAP_DIRECTION)];
    }

    public float getLift() {
        return ((Float)this.field_70180_af.func_187225_a(LIFT)).floatValue();
    }

    public void setLift(float lift) {
        this.field_70180_af.func_187227_b(LIFT, (Object)Float.valueOf(lift));
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    public boolean canChangeWheels() {
        return false;
    }

    public static enum FlapDirection {
        UP,
        DOWN,
        NONE;


        public static FlapDirection fromInput(boolean up, boolean down) {
            return up && !down ? UP : (down && !up ? DOWN : NONE);
        }
    }
}

