/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common.entity;

import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageSyncHeldVehicle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class HeldVehicleDataHandler {
    @CapabilityInject(value=IHeldVehicle.class)
    public static final Capability<IHeldVehicle> CAPABILITY_HELD_VEHICLE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IHeldVehicle.class, (Capability.IStorage)new Storage(), HeldVehicle::new);
        MinecraftForge.EVENT_BUS.register((Object)new HeldVehicleDataHandler());
    }

    public static boolean isHoldingVehicle(PlayerEntity player) {
        IHeldVehicle handler = HeldVehicleDataHandler.getHandler(player);
        if (handler != null) {
            return !handler.getVehicleTag().isEmpty();
        }
        return false;
    }

    public static CompoundNBT getHeldVehicle(PlayerEntity player) {
        IHeldVehicle handler = HeldVehicleDataHandler.getHandler(player);
        if (handler != null) {
            return handler.getVehicleTag();
        }
        return new CompoundNBT();
    }

    public static void setHeldVehicle(PlayerEntity player, CompoundNBT vehicleTag) {
        IHeldVehicle handler = HeldVehicleDataHandler.getHandler(player);
        if (handler != null) {
            handler.setVehicleTag(vehicleTag);
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag));
        }
    }

    @Nullable
    public static IHeldVehicle getHandler(PlayerEntity player) {
        return (IHeldVehicle)player.getCapability(CAPABILITY_HELD_VEHICLE, Direction.DOWN).orElse(null);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("vehicle", "held_vehicle"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            return;
        }
        CompoundNBT vehicleTag = HeldVehicleDataHandler.getHeldVehicle(event.getOriginal());
        if (!vehicleTag.isEmpty()) {
            HeldVehicleDataHandler.setHeldVehicle(event.getPlayer(), vehicleTag);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            CompoundNBT vehicleTag = HeldVehicleDataHandler.getHeldVehicle(player);
            PacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag));
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && !event.getWorld().field_72995_K) {
            PlayerEntity player = (PlayerEntity)entity;
            CompoundNBT vehicleTag = HeldVehicleDataHandler.getHeldVehicle(player);
            PacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncHeldVehicle(player.func_145782_y(), vehicleTag));
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        final IHeldVehicle INSTANCE = (IHeldVehicle)CAPABILITY_HELD_VEHICLE.getDefaultInstance();

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)CAPABILITY_HELD_VEHICLE.getStorage().writeNBT(CAPABILITY_HELD_VEHICLE, (Object)this.INSTANCE, null);
        }

        public void deserializeNBT(CompoundNBT compound) {
            CAPABILITY_HELD_VEHICLE.getStorage().readNBT(CAPABILITY_HELD_VEHICLE, (Object)this.INSTANCE, null, (INBT)compound);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY_HELD_VEHICLE.orEmpty(cap, LazyOptional.of(() -> this.INSTANCE));
        }
    }

    public static class Storage
    implements Capability.IStorage<IHeldVehicle> {
        @Nullable
        public INBT writeNBT(Capability<IHeldVehicle> capability, IHeldVehicle instance, Direction side) {
            return instance.getVehicleTag();
        }

        public void readNBT(Capability<IHeldVehicle> capability, IHeldVehicle instance, Direction side, INBT nbt) {
            instance.setVehicleTag((CompoundNBT)nbt);
        }
    }

    public static class HeldVehicle
    implements IHeldVehicle {
        private CompoundNBT compound = new CompoundNBT();

        @Override
        public void setVehicleTag(CompoundNBT tagCompound) {
            this.compound = tagCompound;
        }

        @Override
        public CompoundNBT getVehicleTag() {
            return this.compound;
        }
    }

    public static interface IHeldVehicle {
        public void setVehicleTag(CompoundNBT var1);

        public CompoundNBT getVehicleTag();
    }
}

