/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.tileentity.VehicleCrateTileEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.EntityType;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleCrateRenderer
extends TileEntityRenderer<VehicleCrateTileEntity> {
    public VehicleCrateRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(VehicleCrateTileEntity crate, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        BlockState state = crate.func_145831_w().func_180495_p(crate.func_174877_v());
        if (state.func_177230_c() != ModBlocks.VEHICLE_CRATE.get()) {
            return;
        }
        matrixStack.func_227860_a_();
        Direction facing = (Direction)state.func_177229_b((Property)BlockRotatedObject.DIRECTION);
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)facing.func_176736_b() * -90.0f + 180.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        this.field_228858_b_.field_147553_e.func_110577_a(AtlasTexture.field_110575_b);
        matrixStack.func_227860_a_();
        light = WorldRenderer.func_228421_a_((IBlockDisplayReader)crate.func_145831_w(), (BlockPos)crate.func_174877_v().func_177984_a());
        if (crate.isOpened() && crate.getTimer() > 150) {
            double progress = Math.min(1.0, (double)Math.max(0.0f, (float)(crate.getTimer() - 150) + 5.0f * partialTicks) / 50.0);
            matrixStack.func_227861_a_(0.0, -0.25 * progress, 0.0);
        }
        for (int i = 0; i < 4; ++i) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(90.0f * (float)i));
            matrixStack.func_227861_a_(0.0, 0.0, 0.5);
            if (crate.isOpened()) {
                double progress = Math.min(1.0, (double)Math.max(0.0f, (float)(crate.getTimer() - i * 20) + 5.0f * partialTicks) / 90.0);
                double angle = progress * progress * 90.0;
                double rotation = 1.0 - Math.cos(Math.toRadians(angle));
                matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_((float)rotation * 90.0f));
            }
            matrixStack.func_227861_a_(0.0, 0.5, 0.0);
            matrixStack.func_227861_a_(0.0, 0.0, -0.125);
            RenderUtil.renderColoredModel(SpecialModels.VEHICLE_CRATE.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        if (!crate.isOpened()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-90.0f));
            matrixStack.func_227862_a_(1.005f, 1.005f, 1.005f);
            matrixStack.func_227861_a_(0.0, 0.0, 0.37424999999999997);
            RenderUtil.renderColoredModel(SpecialModels.VEHICLE_CRATE.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(90.0f));
        matrixStack.func_227862_a_(1.001f, 1.001f, 1.001f);
        matrixStack.func_227861_a_(0.0, 0.0, 0.37424999999999997);
        RenderUtil.renderColoredModel(SpecialModels.VEHICLE_CRATE.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        if (crate.getEntity() != null && crate.isOpened()) {
            matrixStack.func_227861_a_(0.5, 0.0, 0.5);
            double progress = Math.min(1.0, (double)Math.max(0.0f, (float)(crate.getTimer() - 150) + 5.0f * partialTicks) / 100.0);
            Pair<Float, Float> scaleAndOffset = EntityRayTracer.instance().getCrateScaleAndOffset((EntityType<? extends VehicleEntity>)crate.getEntity().func_200600_R());
            float scaleStart = ((Float)scaleAndOffset.getLeft()).floatValue();
            float scale = scaleStart + (1.0f - scaleStart) * (float)progress;
            matrixStack.func_227861_a_(0.0, 0.0, (double)((Float)scaleAndOffset.getRight()).floatValue() * (1.0 - progress) * (double)scale);
            if (crate.getTimer() >= 150) {
                matrixStack.func_227861_a_(0.0, Math.sin(Math.PI * progress) * 5.0, 0.0);
                matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)(720.0 * progress)));
            }
            matrixStack.func_227861_a_(0.0, 0.125 * (1.0 - progress), 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(crate.getEntity());
            renderer.func_225623_a_(crate.getEntity(), 0.0f, partialTicks, matrixStack, renderTypeBuffer, light);
        }
        matrixStack.func_227865_b_();
    }
}

