/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.tileentity.FuelDrumTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FuelDrumRenderer
extends TileEntityRenderer<FuelDrumTileEntity> {
    public static final RenderType LABEL_BACKGROUND = RenderType.func_228632_a_((String)"vehicle:fuel_drum_label_background", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false));
    public static final RenderType LABEL_FLUID = RenderType.func_228632_a_((String)"vehicle:fuel_drum_label_fluid", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PlayerContainer.field_226615_c_, false, true)).func_228728_a_(false));

    public FuelDrumRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FuelDrumTileEntity fuelDrumTileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int lightTexture, int overlayTexture) {
        BlockRayTraceResult result;
        if (Minecraft.func_71410_x().field_71439_g.func_213453_ef() && fuelDrumTileEntity.hasFluid() && this.field_228858_b_.field_190057_j != null && this.field_228858_b_.field_190057_j.func_216346_c() == RayTraceResult.Type.BLOCK && (result = (BlockRayTraceResult)this.field_228858_b_.field_190057_j).func_216350_a().equals((Object)fuelDrumTileEntity.func_174877_v())) {
            this.drawFluidLabel(this.field_228858_b_.field_147557_n, fuelDrumTileEntity.getFluidTank(), matrixStack, renderTypeBuffer);
        }
    }

    private void drawFluidLabel(FontRenderer fontRendererIn, FluidTank tank, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer) {
        if (tank.getFluid().isEmpty()) {
            return;
        }
        FluidStack stack = tank.getFluid();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(tank.getFluid().getFluid().getAttributes().getStillTexture());
        if (sprite != null) {
            float level = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            float width = 30.0f;
            float fuelWidth = width * level;
            float remainingWidth = width - fuelWidth;
            float offsetWidth = width / 2.0f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 1.25, 0.5);
            matrixStack.func_227863_a_(this.field_228858_b_.field_217666_g.func_227995_f_());
            matrixStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
            IVertexBuilder backgroundBuilder = renderTypeBuffer.getBuffer(LABEL_BACKGROUND);
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth - 1.0f, -2.0f, -0.01f).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth - 1.0f, 5.0f, -0.01f).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth + width + 1.0f, 5.0f, -0.01f).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth + width + 1.0f, -2.0f, -0.01f).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            matrixStack.func_227861_a_(0.0, 0.0, -0.05);
            matrix = matrixStack.func_227866_c_().func_227870_a_();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth + fuelWidth, -1.0f, 0.0f).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth + fuelWidth, 4.0f, 0.0f).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth + fuelWidth + remainingWidth, 4.0f, 0.0f).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            backgroundBuilder.func_227888_a_(matrix, -offsetWidth + fuelWidth + remainingWidth, -1.0f, 0.0f).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            float minU = sprite.func_94209_e();
            float maxU = minU + (sprite.func_94212_f() - minU) * level;
            float minV = sprite.func_94206_g();
            float maxV = minV + (sprite.func_94210_h() - minV) * 4.0f * 0.0625f;
            IVertexBuilder fluidBuilder = renderTypeBuffer.getBuffer(LABEL_FLUID);
            fluidBuilder.func_227888_a_(matrix, -offsetWidth, -1.0f, 0.0f).func_225583_a_(minU, maxV).func_181675_d();
            fluidBuilder.func_227888_a_(matrix, -offsetWidth, 4.0f, 0.0f).func_225583_a_(minU, minV).func_181675_d();
            fluidBuilder.func_227888_a_(matrix, -offsetWidth + fuelWidth, 4.0f, 0.0f).func_225583_a_(maxU, minV).func_181675_d();
            fluidBuilder.func_227888_a_(matrix, -offsetWidth + fuelWidth, -1.0f, 0.0f).func_225583_a_(maxU, maxV).func_181675_d();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            String name = stack.getDisplayName().getString();
            int nameWidth = fontRendererIn.func_78256_a(name) / 2;
            fontRendererIn.func_238421_b_(matrixStack, name, (float)(-nameWidth), -14.0f, -1);
            matrixStack.func_227865_b_();
        }
    }
}

