/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.JerryCanItem;
import com.mrcrayfish.vehicle.tileentity.GasPumpTankTileEntity;
import com.mrcrayfish.vehicle.tileentity.GasPumpTileEntity;
import com.mrcrayfish.vehicle.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlockGasPump
extends BlockRotatedObject {
    public static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public BlockGasPump() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151574_g).func_200943_b(1.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
        boolean top = (Boolean)state.func_177229_b((Property)TOP);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        if (top) {
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)3.0, (double)-16.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0), Direction.EAST))[direction.func_176736_b()]);
        } else {
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)31.0, (double)16.0), Direction.EAST))[direction.func_176736_b()]);
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof GasPumpTileEntity) {
                    GasPumpTileEntity gasPump = (GasPumpTileEntity)tileEntity;
                    if (gasPump.getFuelingEntity() != null && gasPump.getFuelingEntity().func_145782_y() == playerEntity.func_145782_y()) {
                        gasPump.setFuelingEntity(null);
                        world.func_184133_a(null, pos, (SoundEvent)ModSounds.NOZZLE_PUT_DOWN.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    } else if (((Direction)state.func_177229_b((Property)DIRECTION)).func_176746_e().equals((Object)result.func_216354_b())) {
                        gasPump.setFuelingEntity(playerEntity);
                        world.func_184133_a(null, pos, (SoundEvent)ModSounds.NOZZLE_PICK_UP.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else {
                ItemStack stack = playerEntity.func_184586_b(hand);
                if (FluidUtil.interactWithFluidHandler((PlayerEntity)playerEntity, (Hand)hand, (World)world, (BlockPos)pos, (Direction)result.func_216354_b())) {
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77973_b() instanceof JerryCanItem) {
                    IFluidHandler handler;
                    JerryCanItem jerryCan = (JerryCanItem)stack.func_77973_b();
                    if (jerryCan.isFull(stack)) {
                        return ActionResultType.SUCCESS;
                    }
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity != null && (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null)) instanceof FluidTank) {
                        int remaining;
                        FluidTank tank = (FluidTank)handler;
                        if (tank.getFluid() != null && tank.getFluid().getFluid() != ModFluids.FUELIUM.get()) {
                            return ActionResultType.SUCCESS;
                        }
                        FluidStack fluidStack = handler.drain(50, IFluidHandler.FluidAction.EXECUTE);
                        if (fluidStack != null && (remaining = jerryCan.fill(stack, fluidStack.getAmount())) > 0) {
                            fluidStack.setAmount(remaining);
                            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        }
                        return ActionResultType.SUCCESS;
                    }
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        return reader.func_175623_d(pos) && reader.func_175623_d(pos.func_177984_a());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177984_a(), (BlockState)state.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGasPump) {
                worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGasPump) {
            worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileEntity;
        BlockPos pos;
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue() && (pos = (BlockPos)builder.func_216019_b(LootParameters.field_216286_f)) != null && (tileEntity = builder.func_216018_a().func_175625_s(pos.func_177977_b())) != null) {
            builder = builder.func_216015_a(LootParameters.field_216288_h, (Object)tileEntity);
        }
        return super.func_220076_a(state, builder);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TOP});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
            return new GasPumpTileEntity();
        }
        return new GasPumpTankTileEntity();
    }
}

