/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.item.JerryCanItem;
import com.mrcrayfish.vehicle.tileentity.FuelDrumTileEntity;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlockFuelDrum
extends BlockRotatedObject {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BlockFuelDrum() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader reader, List<ITextComponent> list, ITooltipFlag advanced) {
        if (Screen.func_231173_s_()) {
            list.addAll(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("tile.vehicle.fuel_drum.info"), 150).stream().map(text -> new StringTextComponent(text.getString())).collect(Collectors.toList()));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0])));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            ItemStack stack = playerEntity.func_184586_b(hand);
            if (FluidUtil.interactWithFluidHandler((PlayerEntity)playerEntity, (Hand)hand, (World)world, (BlockPos)pos, (Direction)result.func_216354_b())) {
                return ActionResultType.SUCCESS;
            }
            if (stack.func_77973_b() instanceof JerryCanItem) {
                JerryCanItem jerryCan = (JerryCanItem)stack.func_77973_b();
                if (jerryCan.isFull(stack)) {
                    return ActionResultType.SUCCESS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                IFluidHandler handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
                if (handler instanceof FluidTank) {
                    int remaining;
                    FluidTank tank = (FluidTank)handler;
                    if (tank.getFluid().getFluid() != ModFluids.FUELIUM.get()) {
                        return ActionResultType.SUCCESS;
                    }
                    FluidStack fluidStack = handler.drain(50, IFluidHandler.FluidAction.EXECUTE);
                    if (!fluidStack.isEmpty() && (remaining = jerryCan.fill(stack, fluidStack.getAmount())) > 0) {
                        fluidStack.setAmount(remaining);
                        handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FuelDrumTileEntity();
    }
}

