/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.base.QuarryBlackList$Air$;
import com.yogpc.qp.machines.base.QuarryBlackList$Entry$;
import com.yogpc.qp.machines.base.QuarryBlackList$Fluids$;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistries;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class QuarryBlackListTest {
    QuarryBlackListTest() {
    }

    static Executable entryTest(QuarryBlackList.Entry entry, BlockState state) {
        return () -> Assertions.assertTrue((boolean)entry.test(state, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a), (String)String.format("Test of %s for %s.", entry, state));
    }

    static Function<BlockState, Executable> getExecutable(QuarryBlackList.Entry entry) {
        return b -> QuarryBlackListTest.entryTest(entry, b);
    }

    @Test
    void airSerialize() {
        QuarryBlackList$Air$ air = QuarryBlackList$Air$.MODULE$;
        INBT n = (INBT)QuarryBlackList.writeEntry(air, NBTDynamicOps.field_210820_a);
        CompoundNBT tag = (CompoundNBT)QuarryBlackList$Entry$.MODULE$.EntryToNBT().apply((Object)air);
        Assertions.assertEquals((Object)n, (Object)tag);
        Assertions.assertTrue((boolean)tag.func_74764_b("id"));
        Assertions.assertEquals((int)1, (int)tag.func_186856_d());
        JsonElement json = (JsonElement)QuarryBlackList.writeEntry(air, JsonOps.INSTANCE);
        Assertions.assertTrue((boolean)json.isJsonObject());
        JsonObject object = json.getAsJsonObject();
        Assertions.assertTrue((boolean)object.has("id"));
        Assertions.assertEquals((int)1, (int)object.size());
        QuarryBlackList.Entry entry = QuarryBlackList.readEntry(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)n));
        Assertions.assertEquals((Object)air, (Object)entry);
        entry = QuarryBlackList.readEntry(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json));
        Assertions.assertEquals((Object)air, (Object)entry);
    }

    @Test
    void airPredicate() {
        Assertions.assertAll(Stream.of(Blocks.field_150350_a, Blocks.field_201941_jj, Blocks.field_201940_ji).map(Block::func_176223_P).map(QuarryBlackListTest.getExecutable(QuarryBlackList$Air$.MODULE$)));
    }

    @Test
    void vanillaPredicate() {
        String blockName = "minecraft:stone";
        QuarryBlackList.VanillaBlockPredicate p = new QuarryBlackList.VanillaBlockPredicate(blockName);
        JsonElement j = (JsonElement)QuarryBlackList.writeEntry(p, JsonOps.INSTANCE);
        QuarryBlackList.Entry loaded = QuarryBlackList.readEntry(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)j));
        Assertions.assertEquals((Object)p, (Object)loaded);
    }

    @Test
    void fluidPredicate() {
        QuarryBlackList$Fluids$ entry = QuarryBlackList$Fluids$.MODULE$;
        Stream<Executable> executable = Stream.concat(ForgeRegistries.FLUIDS.getValues().stream().map(Fluid::func_207188_f).filter(f -> !f.func_206888_e()).map(FluidState::func_206883_i), Stream.of(Blocks.field_150355_j.func_176223_P(), Blocks.field_150353_l.func_176223_P())).map(QuarryBlackListTest.getExecutable(entry));
        Assertions.assertAll(executable);
    }
}

