/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mover;

import com.yogpc.qp.machines.base.IEnchantableItem;
import com.yogpc.qp.machines.base.SlotMover;
import com.yogpc.qp.utils.Holder;
import com.yogpc.qp.utils.LoopList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ContainerMover
extends Container {
    public final IInventory craftMatrix = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            ContainerMover.this.func_75142_b();
        }
    };
    private final World worldObj;
    public final BlockPos pos;
    private final LoopList<Tuple> list = new LoopList();
    private IntReferenceHolder avail = this.func_216958_a(IntReferenceHolder.func_221492_a());

    public ContainerMover(int id, PlayerEntity player, BlockPos pos) {
        super(Holder.moverContainerType(), id);
        int col;
        PlayerInventory inv = player.field_71071_by;
        this.worldObj = player.func_130014_f_();
        this.pos = pos;
        for (col = 0; col < 2; ++col) {
            this.func_75146_a(new SlotMover(this.craftMatrix, col, 8 + col * 144, 35));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)inv, col, 8 + col * 18, 142));
        }
        this.avail.func_221494_a(0);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!this.worldObj.field_72995_K) {
            IntStream.range(0, this.craftMatrix.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)this.craftMatrix).func_70304_b(arg_0)).filter(MapStreamSyntax.not(ItemStack::func_190926_b)).forEach(s -> playerIn.func_71019_a(s, false));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.worldObj.func_180495_p(this.pos).func_177230_c() == Holder.blockMover() && playerIn.func_195048_a(Vector3d.func_237492_c_((Vector3i)this.pos)) <= 64.0;
    }

    public void func_75142_b() {
        ItemStack pickaxe = this.craftMatrix.func_70301_a(0);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)pickaxe);
        ItemStack enchTile = this.craftMatrix.func_70301_a(1);
        if (enchantments.isEmpty() || enchTile.func_190926_b()) {
            this.avail.func_221494_a(0);
            this.list.setList(Collections.emptyList());
        } else {
            int previousSize = this.list.size();
            if (!enchTile.func_190926_b() && enchTile.func_77973_b() instanceof IEnchantableItem) {
                IEnchantableItem item = (IEnchantableItem)enchTile.func_77973_b();
                this.list.setList(enchantments.entrySet().stream().map(Tuple::new).filter(tuple -> item.canMove(enchTile, tuple.enchantment) && EnchantmentHelper.func_77506_a((Enchantment)tuple.enchantment, (ItemStack)enchTile) < tuple.enchantment.func_77325_b()).collect(Collectors.toCollection(LinkedList::new)));
            } else {
                this.list.setList(enchantments.entrySet().stream().map(Tuple::new).collect(Collectors.toCollection(LinkedList::new)));
            }
            if (this.avail.func_221495_b() % (previousSize == 0 ? 1 : previousSize) > this.list.size()) {
                this.avail.func_221494_a(0);
            }
        }
        super.func_75142_b();
    }

    public void setAvail(D d) {
        this.avail.func_221494_a(this.avail.func_221495_b() + d.offset);
        if (!this.worldObj.field_72995_K) {
            this.func_75142_b();
        }
    }

    public Optional<Enchantment> getEnchantment() {
        return this.list.getOptional(this.avail.func_221495_b()).map(tuple -> tuple.enchantment);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack src = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack remain = slot.func_75211_c();
            src = remain.func_77946_l();
            if (index < 2) {
                if (!this.func_75135_a(remain, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                ItemStack put = ItemHandlerHelper.copyStackWithSize((ItemStack)remain, (int)1);
                boolean changed = false;
                Slot toSlot = (Slot)this.field_75151_b.get(0);
                if (toSlot.func_75214_a(remain) && toSlot.func_75211_c().func_190926_b()) {
                    toSlot.func_75215_d(put);
                    remain.func_190918_g(1);
                    changed = true;
                }
                toSlot = (Slot)this.field_75151_b.get(1);
                if (!changed && toSlot.func_75214_a(remain) && toSlot.func_75211_c().func_190926_b()) {
                    toSlot.func_75215_d(put);
                    remain.func_190918_g(1);
                    changed = true;
                }
                if (!changed) {
                    return ItemStack.field_190927_a;
                }
            }
            if (remain.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (remain.func_190916_E() == src.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, remain);
        }
        return src;
    }

    public void moveEnchant() {
        Tuple tuple = this.list.get(this.avail.func_221495_b());
        ItemStack tileItem = this.craftMatrix.func_70301_a(1);
        if (tuple == null || tileItem.func_190926_b() || !((IEnchantableItem)tileItem.func_77973_b()).canMove(tileItem, tuple.enchantment)) {
            return;
        }
        ListNBT list = tileItem.func_77986_q();
        if (EnchantmentHelper.func_77506_a((Enchantment)tuple.enchantment, (ItemStack)tileItem) == 0) {
            tileItem.func_77966_a(tuple.enchantment, 1);
            if (tuple.level == 1) {
                this.list.remove(this.avail.func_221495_b());
            } else {
                this.list.set(this.avail.func_221495_b(), tuple.levelDown());
            }
            ContainerMover.downLevel(tuple.enchantment, this.craftMatrix.func_70301_a(0));
        } else {
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT nbt = list.func_150305_b(i);
                if (ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.func_74779_i("id"))) != tuple.enchantment) continue;
                short l = nbt.func_74765_d("lvl");
                if (l < tuple.enchantment.func_77325_b()) {
                    nbt.func_74777_a("lvl", (short)(l + 1));
                    if (tuple.level == 1) {
                        this.list.remove(this.avail.func_221495_b());
                    } else {
                        this.list.set(this.avail.func_221495_b(), tuple.levelDown());
                    }
                    ContainerMover.downLevel(tuple.enchantment, this.craftMatrix.func_70301_a(0));
                }
                return;
            }
        }
    }

    private static void downLevel(Enchantment enchantment, ItemStack stack) {
        CompoundNBT compound;
        ListNBT list = stack.func_77986_q();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt = list.func_150305_b(i);
            if (ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.func_74779_i("id"))) != enchantment) continue;
            short l = nbt.func_74765_d("lvl");
            if (l == 1) {
                list.remove(i);
                break;
            }
            nbt.func_74777_a("lvl", (short)(l - 1));
            break;
        }
        if (list.isEmpty() && (compound = stack.func_77978_p()) != null) {
            compound.func_82580_o("ench");
            if (compound.isEmpty()) {
                stack.func_77982_d(null);
            }
        }
    }

    private static class Tuple {
        final Enchantment enchantment;
        final int level;

        public Tuple(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            this.level = level;
        }

        public Tuple(Map.Entry<Enchantment, Integer> entry) {
            this(entry.getKey(), entry.getValue());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple) {
                Tuple tuple = (Tuple)obj;
                return tuple.enchantment == this.enchantment && tuple.level == this.level;
            }
            return false;
        }

        public int hashCode() {
            return this.enchantment.hashCode() ^ this.level;
        }

        public Tuple levelDown() {
            return this.cloneWithLevel(this.level - 1);
        }

        public Tuple cloneWithLevel(int newLevel) {
            return new Tuple(this.enchantment, newLevel);
        }

        public String toString() {
            return "Tuple{enchantment=" + this.enchantment.getRegistryName() + ", level=" + this.level + '}';
        }
    }

    public static enum D {
        UP(-1),
        DOWN(1);

        public final int offset;

        private D(int offset) {
            this.offset = offset;
        }
    }
}

