/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.base.QuarryBlackList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MiniQuarryAddEntryGui
extends Screen
implements IHandleButton {
    @Nonnull
    private final Screen parent;
    private final Consumer<QuarryBlackList.Entry> callback;
    private EntryList list;
    private TextFieldWidget textField;

    protected MiniQuarryAddEntryGui(Screen parent, Consumer<QuarryBlackList.Entry> callback) {
        super(parent.func_231171_q_());
        this.parent = parent;
        this.callback = callback;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int buttonWidth = 80;
        int width = this.field_230708_k_;
        int height = this.field_230709_l_;
        FontRenderer font = this.field_230712_o_;
        this.textField = new TextFieldWidget(font, width / 2 - 125, height - 56, 250, 20, (ITextComponent)new StringTextComponent(""));
        this.textField.func_146203_f(512);
        this.list = new EntryList(this.getMinecraft(), width, height, 30, height - 70, 18, this, this::getEntries);
        this.func_230480_a_((Widget)new IHandleButton.Button(1, width / 2 - buttonWidth / 2, height - 35, buttonWidth, 20, I18n.func_135052_a((String)"tof.addnewore", (Object[])new Object[0]), (IHandleButton)this));
        this.field_230705_e_.add(this.list);
        this.field_230705_e_.add(this.textField);
        this.func_231035_a_((IGuiEventListener)this.list);
        this.textField.func_146205_d(true);
        this.textField.func_212954_a(s -> {
            this.list.updateList();
            this.list.func_230932_a_(this.list.func_230966_l_());
        });
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.textField.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        String title = I18n.func_135052_a((String)"quarryplus.gui.new_entry", (Object[])new Object[0]);
        this.func_238471_a_(matrixStack, this.field_230712_o_, title, this.field_230708_k_ / 2, 8, 0xFFFFFF);
    }

    private Pair<Kind, List<ResourceLocation>> getEntries() {
        String filterText;
        String string = filterText = this.textField == null ? "" : this.textField.func_146179_b();
        if (filterText.startsWith("#")) {
            String f = filterText.substring(1);
            return Pair.of((Object)((Object)Kind.TAG), BlockTags.func_199896_a().func_199908_a().stream().filter(r -> r.toString().contains(f)).sorted().collect(Collectors.toList()));
        }
        return Pair.of((Object)((Object)Kind.BLOCK), ForgeRegistries.BLOCKS.getKeys().stream().filter(r -> r.toString().contains(filterText)).sorted().collect(Collectors.toList()));
    }

    @Override
    public void actionPerformed(IHandleButton.Button button) {
        if (button.id == 1) {
            LocationEntry entry = (LocationEntry)this.list.func_230958_g_();
            if (entry != null) {
                ResourceLocation location = entry.getData();
                switch (entry.getKind()) {
                    case BLOCK: {
                        this.callback.accept(new QuarryBlackList.Name(location));
                        break;
                    }
                    case TAG: {
                        this.callback.accept(new QuarryBlackList.Tag(location));
                        break;
                    }
                    default: {
                        QuarryPlus.LOGGER.warn("Not registered kind {} for {}.", (Object)entry.getKind(), (Object)location);
                        break;
                    }
                }
            } else {
                String maybePredicate = this.textField.func_146179_b();
                if (!maybePredicate.isEmpty()) {
                    try {
                        new BlockStateParser(new StringReader(maybePredicate), true).func_197243_a(true);
                        this.callback.accept(new QuarryBlackList.VanillaBlockPredicate(maybePredicate));
                    }
                    catch (CommandSyntaxException e) {
                        QuarryPlus.LOGGER.debug("Invalid predicate {} was parsed but not added. Got {}.", (Object)maybePredicate, (Object)e);
                    }
                }
            }
            this.func_231175_as__();
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.textField.func_230999_j_() && this.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_231175_as__() {
        this.getMinecraft().func_147108_a(this.parent);
    }

    private static enum Kind {
        BLOCK,
        TAG;

    }

    static class LocationEntry
    extends ExtendedList.AbstractListEntry<LocationEntry> {
        private final ResourceLocation data;
        private final Screen parent;
        private final Consumer<LocationEntry> setSelected;
        private final Kind kind;

        LocationEntry(ResourceLocation data, Screen parent, Consumer<LocationEntry> setSelected, Kind kind) {
            this.data = data;
            this.parent = parent;
            this.setSelected = setSelected;
            this.kind = kind;
        }

        public ResourceLocation getData() {
            return this.data;
        }

        public Kind getKind() {
            return this.kind;
        }

        public void func_230432_a_(MatrixStack m, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_render_8_, float partialTicks) {
            String name = (this.kind == Kind.TAG ? "#" : "") + this.data.toString();
            Minecraft.func_71410_x().field_71466_p.func_238405_a_(m, name, (float)((this.parent.field_230708_k_ - Minecraft.func_71410_x().field_71466_p.func_78256_a(name)) / 2), (float)(top + 2), 0xFFFFFF);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            this.setSelected.accept(this);
            return false;
        }
    }

    static class EntryList
    extends ExtendedList<LocationEntry> {
        private final Screen parent;
        private final Supplier<Pair<Kind, List<ResourceLocation>>> entriesSupplier;

        public EntryList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, Screen parent, Supplier<Pair<Kind, List<ResourceLocation>>> entriesSupplier) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
            this.parent = parent;
            this.entriesSupplier = entriesSupplier;
            this.updateList();
        }

        public void updateList() {
            this.func_230963_j_();
            Pair<Kind, List<ResourceLocation>> kindListPair = this.entriesSupplier.get();
            ((List)kindListPair.getValue()).stream().map(e -> new LocationEntry((ResourceLocation)e, this.parent, arg_0 -> ((EntryList)this).func_241215_a_(arg_0), (Kind)((Object)((Object)kindListPair.getKey())))).forEach(arg_0 -> ((EntryList)this).func_230513_b_(arg_0));
        }
    }
}

