/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.generator.creative;

import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.utils.Holder;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;
import scala.Symbol;

public class CreativeGeneratorTile
extends APacketTile
implements ITickableTileEntity {
    public static final Symbol SYMBOL = Symbol.apply((String)"CreativeGenerator");
    public long sendAmount = 1000000000L;
    private final LazyOptional<IEnergyStorage> handlerOptional = LazyOptional.of(() -> new Handler());

    public CreativeGeneratorTile() {
        super(Holder.creativeGeneratorType());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Arrays.stream(Direction.values()).map(d -> Pair.of((Object)d, (Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d)))).filter(MapStreamSyntax.byValue(Objects::nonNull)).map(MapStreamSyntax.toAny((direction, t) -> t.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()))).forEach(l -> l.ifPresent(e -> {
                if (e instanceof APowerTile) {
                    ((APowerTile)((Object)((Object)e))).getEnergy(this.sendAmount, true);
                } else {
                    int accepted = e.receiveEnergy(this.energyInFE(), true);
                    if (accepted > 0) {
                        e.receiveEnergy(accepted, false);
                    }
                }
            }));
        }
    }

    private int energyInFE() {
        return (int)(this.sendAmount / 100000L);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.sendAmount = nbt.func_74763_f("sendAmount");
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a("sendAmount", this.sendAmount);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.handlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    class Handler
    implements IEnergyStorage {
        Handler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return Math.min(maxExtract, this.getEnergyStored());
        }

        public int getEnergyStored() {
            return CreativeGeneratorTile.this.energyInFE();
        }

        public int getMaxEnergyStored() {
            return CreativeGeneratorTile.this.energyInFE();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

