/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.controller.GuiSlotEntities;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.controller.SetEntity;
import com.yogpc.qp.utils.Holder;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiController
extends Screen
implements IHandleButton {
    private GuiSlotEntities slot;
    private TextFieldWidget search;
    List<ResourceLocation> names;
    @Nonnull
    private final List<ResourceLocation> allEntities;
    ResourceLocation dim;
    final int xc;
    final int yc;
    final int zc;

    public GuiController(ResourceLocation d, int x, int y, int z, List<ResourceLocation> allEntities) {
        super((ITextComponent)new TranslationTextComponent(Holder.blockController().func_149739_a()));
        this.dim = d;
        this.xc = x;
        this.yc = y;
        this.zc = z;
        this.allEntities = allEntities;
        this.names = allEntities.stream().sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int width = this.field_230708_k_;
        int height = this.field_230709_l_;
        this.slot = new GuiSlotEntities(this.getMinecraft(), width, height, 30, height - 60, 18, this);
        this.field_230705_e_.add(this.slot);
        this.func_231035_a_((IGuiEventListener)this.slot);
        this.func_230480_a_((Widget)new IHandleButton.Button(-1, width / 2 - 125, height - 26, 250, 20, (ITextComponent)new TranslationTextComponent("gui.done"), (IHandleButton)this));
        this.search = new TextFieldWidget(this.field_230712_o_, width / 2 - 125, height - 56, 250, 20, (ITextComponent)new StringTextComponent(""));
        this.field_230705_e_.add(this.search);
        this.search.func_146205_d(true);
        this.search.func_212954_a(this::searchEntities);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.slot != null) {
            this.slot.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.search.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_238472_a_(matrixStack, this.field_230712_o_, (ITextProperties)new TranslationTextComponent("yog.spanwer.setting"), this.field_230708_k_ / 2, 8, 0xFFFFFF);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.getMinecraft().field_71439_g.func_70089_S()) {
            this.getMinecraft().field_71439_g.func_71053_j();
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.search.func_230999_j_() && this.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public void actionPerformed(IHandleButton.Button button) {
        if (button.id == -1) {
            GuiSlotEntities.Entry selected = (GuiSlotEntities.Entry)this.slot.func_230958_g_();
            if (selected != null) {
                PacketHandler.sendToServer(SetEntity.create(this.dim, new BlockPos(this.xc, this.yc, this.zc), selected.location));
            }
            this.getMinecraft().field_71439_g.func_71053_j();
        }
    }

    public void buildModList(Consumer<GuiSlotEntities.Entry> modListViewConsumer, Function<ResourceLocation, GuiSlotEntities.Entry> newEntry) {
        this.names.stream().map(newEntry).forEach(modListViewConsumer);
    }

    public void searchEntities(String text) {
        List collect;
        if (!text.isEmpty()) {
            try {
                Pattern pattern = Pattern.compile(text);
                collect = this.allEntities.stream().filter(l -> pattern.matcher(l.toString()).find()).sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
            }
            catch (PatternSyntaxException e) {
                collect = this.allEntities.stream().filter(l -> l.toString().contains(text)).sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
            }
        } else {
            collect = this.allEntities.stream().sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
        }
        this.names = collect;
        this.slot.refreshList();
        this.slot.func_241215_a_(null);
    }
}

