/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.yogpc.qp.Config;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.IDisabled;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.controller.AvailableEntities;
import com.yogpc.qp.utils.Holder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import scala.Symbol;

public class BlockController
extends Block
implements IDisabled {
    private static final Field logic_spawnDelay;
    private static final Method logic_getEntityID;
    public static final Symbol SYMBOL;
    public final BlockItem itemBlock;

    public BlockController() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(1.0f));
        this.setRegistryName("quarryplus", "spawnercontroller");
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
        this.itemBlock = new BlockItem((Block)this, new Item.Properties().func_200916_a((ItemGroup)Holder.tab()));
        this.itemBlock.setRegistryName("quarryplus", "spawnercontroller");
    }

    public Item func_199767_j() {
        return this.itemBlock;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{QPBlock.WORKING()});
    }

    private static Optional<AbstractSpawner> getSpawner(World world, BlockPos pos) {
        return Stream.of(Direction.values()).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(MobSpawnerTileEntity.class)).map(MobSpawnerTileEntity::func_145881_a).findFirst();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (super.func_225533_a_(state, worldIn, pos, player, hand, hit).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                if (player.func_184586_b(hand).func_77973_b() == Holder.itemStatusChecker()) {
                    BlockController.getSpawner(worldIn, pos).flatMap(logic -> Optional.ofNullable(APacketTile.invoke(logic_getEntityID, ResourceLocation.class, logic, new Object[0]))).map(ResourceLocation::toString).map(s -> "Spawner Mob: " + s).map(StringTextComponent::new).ifPresent(s -> player.func_146105_b((ITextComponent)s, false));
                } else if (this.enabled()) {
                    List<EntityType<?>> entries = ForgeRegistries.ENTITIES.getValues().stream().filter(e -> !Config.common().spawnerBlacklist().contains((Object)e.getRegistryName())).collect(Collectors.toList());
                    PacketHandler.sendToClient(AvailableEntities.create(pos, worldIn, entries), worldIn);
                } else {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Spawner Controller is disabled."), true);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void setSpawnerEntity(World world, BlockPos pos, ResourceLocation name) {
        BlockController.getSpawner(world, pos).ifPresent(logic -> {
            Optional.of(name).filter(n -> !Config.common().spawnerBlacklist().contains(n)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getValue(arg_0)).ifPresent(arg_0 -> ((AbstractSpawner)logic).func_200876_a(arg_0));
            Optional.ofNullable(logic.func_98271_a().func_175625_s(logic.func_177221_b())).ifPresent(TileEntity::func_70296_d);
            BlockState state = logic.func_98271_a().func_180495_p(logic.func_177221_b());
            logic.func_98271_a().func_184138_a(logic.func_177221_b(), state, state, 3);
        });
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && !((Boolean)((ForgeConfigSpec.BooleanValue)Config.common().disabled().apply((Object)SYMBOL)).get()).booleanValue()) {
            boolean powered = worldIn.func_175640_z(pos);
            boolean m = (Boolean)state.func_177229_b((Property)QPBlock.WORKING());
            if (powered && !m) {
                BlockController.getSpawner(worldIn, pos).ifPresent(logic -> {
                    try {
                        logic_spawnDelay.setInt(logic, 0);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return;
                    }
                    FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)worldIn));
                    fakePlayer.func_70029_a(logic.func_98271_a());
                    fakePlayer.func_70107_b((double)logic.func_177221_b().func_177958_n(), (double)logic.func_177221_b().func_177956_o(), (double)logic.func_177221_b().func_177952_p());
                    logic.func_98278_g();
                });
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)QPBlock.WORKING(), (Comparable)Boolean.valueOf(powered)));
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    @Override
    public Symbol getSymbol() {
        return SYMBOL;
    }

    @Override
    public boolean defaultDisableMachine() {
        return true;
    }

    static {
        SYMBOL = Symbol.apply((String)"SpawnerController");
        logic_spawnDelay = ObfuscationReflectionHelper.findField(AbstractSpawner.class, (String)"field_98286_b");
        logic_getEntityID = ObfuscationReflectionHelper.findMethod(AbstractSpawner.class, (String)"func_190895_g", (Class[])new Class[0]);
    }
}

