/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.machines.modules.IModuleItem;
import com.yogpc.qp.utils.Holder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class QuarryModuleInventory
extends Inventory
implements INBTSerializable<CompoundNBT> {
    private final TileEntity tile;
    private final Consumer<QuarryModuleInventory> onUpdate;
    private final Predicate<IModuleItem> moduleFilter;
    public final IItemHandlerModifiable itemHandler = new ItemHandler();

    public QuarryModuleInventory(int slotCount, TileEntity entity, Consumer<QuarryModuleInventory> onUpdate, Predicate<IModuleItem> moduleFilter) {
        super(slotCount);
        this.tile = Objects.requireNonNull(entity);
        this.onUpdate = Objects.requireNonNull(onUpdate);
        this.moduleFilter = moduleFilter;
    }

    public List<Map.Entry<IModuleItem, ItemStack>> moduleItems() {
        return IntStream.range(0, this.func_70302_i_()).mapToObj(arg_0 -> ((QuarryModuleInventory)this).func_70301_a(arg_0)).filter(s -> !s.func_190926_b()).map(MapStreamSyntax.toEntry(ItemStack::func_77973_b, Function.identity())).filter(MapStreamSyntax.byKey(IModuleItem.class::isInstance)).map(MapStreamSyntax.keys(IModuleItem.class::cast)).filter(MapStreamSyntax.byKey(this.moduleFilter)).collect(Collectors.toList());
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_77973_b() instanceof IModuleItem) {
            IModuleItem item = (IModuleItem)stack.func_77973_b();
            if (!this.moduleFilter.test(item)) {
                return false;
            }
            if (item.getSymbol().equals((Object)Holder.itemFuelModuleNormal().getSymbol())) {
                return index == 4;
            }
            Predicate<Item> id = item1 -> item1 instanceof IModuleItem && !((IModuleItem)item1).isCompatibleWith(item);
            return IntStream.range(0, this.func_70302_i_()).mapToObj(arg_0 -> ((QuarryModuleInventory)this).func_70301_a(arg_0)).map(ItemStack::func_77973_b).noneMatch(id);
        }
        return false;
    }

    public boolean func_70300_a(PlayerEntity player) {
        BlockPos pos = this.tile.func_174877_v();
        return player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 64.0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.onUpdate.accept(this);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        NonNullList list = IntStream.range(0, this.func_70302_i_()).mapToObj(arg_0 -> ((QuarryModuleInventory)this).func_70301_a(arg_0)).collect(Collectors.toCollection(NonNullList::func_191196_a));
        ItemStackHelper.func_191282_a((CompoundNBT)nbtTagCompound, (NonNullList)list);
        return nbtTagCompound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        NonNullList list = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)list);
        for (int i = 0; i < list.size(); ++i) {
            this.func_70299_a(i, (ItemStack)list.get(i));
        }
    }

    private class ItemHandler
    extends InvWrapper {
        public ItemHandler() {
            super((IInventory)QuarryModuleInventory.this);
        }

        public int getSlotLimit(int slot) {
            if (slot == 4) {
                return super.getSlotLimit(slot);
            }
            return 1;
        }
    }
}

