/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.QuarryPlus;
import java.util.Optional;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public interface IChunkLoadTile {
    default public void requestTicket() {
        Optional.ofNullable(((TileEntity)this).func_145831_w()).flatMap(MapStreamSyntax.optCast(ServerWorld.class)).ifPresent(worldServer -> {
            BlockPos blockPos = ((TileEntity)this).func_174877_v();
            ChunkPos pos = new ChunkPos(blockPos);
            MinecraftForge.EVENT_BUS.register((Object)this);
            worldServer.func_217458_b(pos.field_77276_a, pos.field_77275_b, true);
            QuarryPlus.LOGGER.debug(String.format("QuarryPlus ChunkLoader added [%d, %d] for %s", pos.field_77276_a, pos.field_77275_b, this));
        });
    }

    default public void releaseTicket() {
        Optional.ofNullable(((TileEntity)this).func_145831_w()).flatMap(MapStreamSyntax.optCast(ServerWorld.class)).ifPresent(worldServer -> {
            BlockPos blockPos = ((TileEntity)this).func_174877_v();
            ChunkPos pos = new ChunkPos(blockPos);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            if (!MinecraftForge.EVENT_BUS.post((Event)new ReleaseChunkLoadEvent((IWorld)worldServer, pos))) {
                worldServer.func_217458_b(pos.field_77276_a, pos.field_77275_b, false);
                QuarryPlus.LOGGER.debug(String.format("QuarryPlus ChunkLoader removed [%d, %d] for %s", pos.field_77276_a, pos.field_77275_b, this));
            }
        });
    }

    @Cancelable
    public static class ReleaseChunkLoadEvent
    extends WorldEvent {
        public final ChunkPos pos;

        public ReleaseChunkLoadEvent(IWorld world, ChunkPos pos) {
            super(world);
            this.pos = pos;
        }
    }
}

