/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.Config;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.exppump.BlockExpPump;
import com.yogpc.qp.machines.exppump.TileExpPump;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.machines.replacer.TileReplacer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ForgeConfigSpec;

public interface IAttachment {
    public void setConnectTo(@Nullable Direction var1);

    public IModule getModule();

    public static class Attachments<T extends APacketTile>
    implements Predicate<TileEntity>,
    Function<TileEntity, Optional<T>> {
        public static final Attachments<TilePump> FLUID_PUMP = new Attachments("FLUID_PUMP", () -> (Boolean)((ForgeConfigSpec.BooleanValue)Config.common().disabled().apply((Object)TilePump.SYMBOL)).get(), (APacketTile[])new TilePump[0]);
        public static final Attachments<TileExpPump> EXP_PUMP = new Attachments("EXP_PUMP", () -> (Boolean)((ForgeConfigSpec.BooleanValue)Config.common().disabled().apply((Object)BlockExpPump.SYMBOL)).get(), (APacketTile[])new TileExpPump[0]);
        public static final Attachments<TileReplacer> REPLACER = new Attachments("REPLACER", () -> (Boolean)((ForgeConfigSpec.BooleanValue)Config.common().disabled().apply((Object)TileReplacer.SYMBOL)).get(), (APacketTile[])new TileReplacer[0]);
        public static final Set<Attachments<? extends APacketTile>> ALL = Collections.unmodifiableSet(Arrays.stream(Attachments.class.getDeclaredFields()).filter(field -> field.getType() == Attachments.class).map(field -> {
            try {
                return (Attachments)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet()));
        @Nonnull
        private final String name;
        @Nonnull
        private final BooleanSupplier isDisabled;
        @Nonnull
        private final Class<T> clazz;

        private Attachments(@Nonnull String name, @Nonnull BooleanSupplier isDisabled, T ... ts) {
            this.name = name;
            this.isDisabled = isDisabled;
            this.clazz = ts.getClass().getComponentType();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Optional<T> apply(TileEntity tileEntity) {
            if (this.test(tileEntity)) {
                return Optional.of(this.clazz.cast(tileEntity));
            }
            return Optional.empty();
        }

        @Override
        public boolean test(TileEntity tileEntity) {
            return this.clazz.isInstance(tileEntity) && !this.isDisabled.getAsBoolean();
        }

        public Optional<IModule> module(TileEntity tileEntity) {
            return Optional.ofNullable(tileEntity).flatMap(MapStreamSyntax.optCast(IAttachment.class)).map(IAttachment::getModule);
        }

        static {
            assert (!ALL.isEmpty());
        }
    }
}

