/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker;

import com.kotori316.marker.IAreaConfigurable;
import com.kotori316.marker.Marker;
import com.kotori316.marker.render.Box;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

public class Tile16Marker
extends TileEntity
implements IAreaConfigurable {
    private BlockPos min = BlockPos.field_177992_a;
    private BlockPos max = BlockPos.field_177992_a;
    @Nullable
    public Box[] boxes;
    private boolean bcLoaded = ModList.get().isLoaded("buildcraftlib");
    private Direction.AxisDirection xDirection = Direction.AxisDirection.NEGATIVE;
    private Direction.AxisDirection zDirection = Direction.AxisDirection.POSITIVE;
    private int size = 16;

    public Tile16Marker() {
        super(Marker.Entries.TYPE16);
    }

    public void init(Direction.AxisDirection xDirection, Direction.AxisDirection zDirection) {
        this.xDirection = Objects.requireNonNull(xDirection);
        this.zDirection = Objects.requireNonNull(zDirection);
        this.changeSize(this.size);
    }

    public void changeSize(int size) {
        int y = this.func_174877_v().func_177956_o();
        this.changeSize(size, y, y);
    }

    public void changeSize(int size, int yMax, int yMin) {
        this.size = size;
        BlockPos edge1 = this.func_174877_v().func_177982_a(this.xDirection.func_179524_a() * (size + 1), 0, this.zDirection.func_179524_a() * (size + 1));
        BlockPos edge2 = this.func_174877_v();
        this.min = new BlockPos(Math.min(edge1.func_177958_n(), edge2.func_177958_n()), yMin, Math.min(edge1.func_177952_p(), edge2.func_177952_p()));
        this.max = new BlockPos(Math.max(edge1.func_177958_n(), edge2.func_177958_n()), yMax, Math.max(edge1.func_177952_p(), edge2.func_177952_p()));
        this.setRender();
    }

    private void setRender() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.boxes = IAreaConfigurable.getRenderBox(this.min, this.max);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSize() {
        return this.size;
    }

    public CompoundNBT func_189517_E_() {
        return super.serializeNBT();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 32768.0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.min = BlockPos.func_218283_e((long)compound.func_74763_f("min"));
        this.max = BlockPos.func_218283_e((long)compound.func_74763_f("max"));
        this.xDirection = compound.func_74767_n("x") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.zDirection = compound.func_74767_n("z") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.size = compound.func_74762_e("size");
        if (this.func_145830_o()) {
            this.setRender();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a("min", this.min.func_218275_a());
        compound.func_74772_a("max", this.max.func_218275_a());
        compound.func_74757_a("x", this.xDirection == Direction.AxisDirection.POSITIVE);
        compound.func_74757_a("z", this.zDirection == Direction.AxisDirection.POSITIVE);
        compound.func_74768_a("size", this.size);
        return super.func_189515_b(compound);
    }

    public BlockPos min() {
        return this.min == BlockPos.field_177992_a ? this.func_174877_v() : this.min;
    }

    public BlockPos max() {
        return this.max == BlockPos.field_177992_a ? this.func_174877_v() : this.max;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Runnable setMinMax(BlockPos min, BlockPos max) {
        return () -> {
            this.max = max;
            this.min = min;
            this.setRender();
            this.size = max.func_177958_n() - min.func_177958_n() - 1;
        };
    }
}

