/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker;

import com.kotori316.marker.ChunkMarkerInstance;
import com.kotori316.marker.FlexMarkerInstance;
import com.kotori316.marker.Tile16Marker;
import com.kotori316.marker.TileFlexMarker;
import com.yogpc.qp.machines.base.IMarker;
import com.yogpc.qp.machines.base.IRemotePowerOn;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class Caps {
    public static boolean isQuarryModLoaded() {
        return ModList.get().isLoaded("quarryplus");
    }

    public static Optional<Capability<IMarker>> markerCapability() {
        if (Caps.isQuarryModLoaded()) {
            return Optional.ofNullable(QuarryPlus.MARKER_CAPABILITY);
        }
        return Optional.empty();
    }

    public static Optional<Capability<IRemotePowerOn>> remotePowerOnCapability() {
        if (Caps.isQuarryModLoaded()) {
            return Optional.ofNullable(QuarryPlus.REMOTE_POWER_ON_CAPABILITY);
        }
        return Optional.empty();
    }

    public static final class Event {
        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<TileEntity> event) {
            if (Caps.isQuarryModLoaded() && (event.getObject() instanceof Tile16Marker || event.getObject() instanceof TileFlexMarker)) {
                event.addCapability(new ResourceLocation("quarryplus", "capability_marker"), (ICapabilityProvider)new Provider((TileEntity)event.getObject()));
            }
        }

        private static final class Provider
        implements ICapabilityProvider {
            private final IMarker marker;

            private Provider(TileEntity tileEntity) {
                if (tileEntity instanceof TileFlexMarker) {
                    TileFlexMarker marker = (TileFlexMarker)tileEntity;
                    this.marker = new FlexMarkerInstance(marker);
                } else if (tileEntity instanceof Tile16Marker) {
                    Tile16Marker marker = (Tile16Marker)tileEntity;
                    this.marker = new ChunkMarkerInstance(marker);
                } else {
                    this.marker = IMarker.EMPTY_MARKER;
                }
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return Caps.markerCapability().map(c -> c.orEmpty(cap, LazyOptional.of(() -> this.marker))).orElse(LazyOptional.empty());
            }
        }
    }

    public static final class QuarryPlus {
        @CapabilityInject(value=IMarker.class)
        public static final Capability<IMarker> MARKER_CAPABILITY = null;
        @CapabilityInject(value=IRemotePowerOn.class)
        public static final Capability<IRemotePowerOn> REMOTE_POWER_ON_CAPABILITY = null;
    }
}

