/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.FurnitureConfig;
import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.inventory.container.MailBoxContainer;
import com.mrcrayfish.furniture.tileentity.BasicLootTileEntity;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MailBoxTileEntity
extends BasicLootTileEntity
implements ITickableTileEntity {
    private UUID id;
    private String name;
    private String ownerName;
    private UUID ownerId;

    public MailBoxTileEntity() {
        super(ModTileEntities.MAIL_BOX);
    }

    public void setId(UUID id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public UUID getId() {
        return this.id;
    }

    public void setMailBoxName(String name) {
        this.name = name;
    }

    public String getMailBoxName() {
        return this.name;
    }

    public void setOwner(ServerPlayerEntity entity) {
        this.ownerId = entity.func_110124_au();
        this.ownerName = entity.func_200200_C_().getString();
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (!this.isFull() && this.ownerId != null && this.id != null && server.func_71259_af() % (Integer)FurnitureConfig.COMMON.pullMailInterval.get() == 0) {
                Mail mail;
                Supplier<Mail> supplier = PostOffice.getMailForPlayerMailBox(this.ownerId, this.id);
                while (!this.isFull() && (mail = supplier.get()) != null) {
                    this.addItem(mail.getStack());
                }
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return 18;
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cfm.mail_box", new Object[]{this.ownerName, this.name});
    }

    @Override
    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new MailBoxContainer(windowId, playerInventory, this);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.readData(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeData(compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.writeData(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.readData(compound);
    }

    private void readData(CompoundNBT compound) {
        if (compound.func_186855_b("MailBoxUUID")) {
            this.id = compound.func_186857_a("MailBoxUUID");
        }
        if (compound.func_150297_b("MailBoxName", 8)) {
            this.name = compound.func_74779_i("MailBoxName");
        }
        if (compound.func_150297_b("OwnerName", 8)) {
            this.ownerName = compound.func_74779_i("OwnerName");
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerId = compound.func_186857_a("OwnerUUID");
        }
    }

    private CompoundNBT writeData(CompoundNBT compound) {
        if (this.id != null) {
            compound.func_186854_a("MailBoxUUID", this.id);
        }
        if (this.name != null) {
            compound.func_74778_a("MailBoxName", this.name);
        }
        if (this.ownerName != null && this.ownerId != null) {
            compound.func_74778_a("OwnerName", this.ownerName);
            compound.func_186854_a("OwnerUUID", this.ownerId);
        }
        return compound;
    }
}

