/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.google.common.collect.Maps;
import com.mrcrayfish.furniture.block.FreezerBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.event.FreezerFuelTimeEvent;
import com.mrcrayfish.furniture.inventory.container.FreezerContainer;
import com.mrcrayfish.furniture.item.crafting.RecipeType;
import com.mrcrayfish.furniture.tileentity.BasicLootTileEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class FreezerTileEntity
extends BasicLootTileEntity
implements ITickableTileEntity {
    private static final int[] SLOTS_SOURCE = new int[]{0};
    private static final int[] SLOTS_FUEL = new int[]{1};
    private static final int[] SLOTS_RESULT = new int[]{2};
    private int fuelTime;
    private int fuelTimeTotal;
    private int freezeTime;
    private int freezeTimeTotal;
    private int playerCount;
    protected final IIntArray freezerData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return FreezerTileEntity.this.fuelTime;
                }
                case 1: {
                    return FreezerTileEntity.this.fuelTimeTotal;
                }
                case 2: {
                    return FreezerTileEntity.this.freezeTime;
                }
                case 3: {
                    return FreezerTileEntity.this.freezeTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerTileEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    FreezerTileEntity.this.fuelTimeTotal = value;
                    break;
                }
                case 2: {
                    FreezerTileEntity.this.freezeTime = value;
                    break;
                }
                case 3: {
                    FreezerTileEntity.this.freezeTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Map<ResourceLocation, Integer> usedRecipeCount = Maps.newHashMap();

    public FreezerTileEntity() {
        super(ModTileEntities.FREEZER);
    }

    public void func_73660_a() {
        boolean freezing = this.isFreezing();
        boolean shouldMarkDirty = false;
        if (this.isFreezing()) {
            --this.fuelTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = (ItemStack)this.inventory.get(1);
            if (this.isFreezing() || !fuelStack.func_190926_b() && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                IRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeType.FREEZER_SOLIDIFY, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isFreezing() && this.canFreeze(recipe)) {
                    this.fuelTimeTotal = this.fuelTime = this.getFreezeTime(fuelStack);
                    if (this.isFreezing()) {
                        shouldMarkDirty = true;
                        if (fuelStack.hasContainerItem()) {
                            this.inventory.set(1, (Object)fuelStack.getContainerItem());
                        } else if (!fuelStack.func_190926_b()) {
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190926_b()) {
                                this.inventory.set(1, (Object)fuelStack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isFreezing() && this.canFreeze(recipe)) {
                    ++this.freezeTime;
                    if (this.freezeTime == this.freezeTimeTotal) {
                        this.freezeTime = 0;
                        this.freezeTimeTotal = this.getFreezeTime();
                        this.freeze(recipe);
                        shouldMarkDirty = true;
                    }
                } else {
                    this.freezeTime = 0;
                }
            } else if (this.freezeTime > 0) {
                this.freezeTime = MathHelper.func_76125_a((int)(this.freezeTime - 2), (int)0, (int)this.freezeTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            this.func_70296_d();
        }
    }

    private boolean isFreezing() {
        return this.fuelTime > 0;
    }

    public int getFreezeTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Items.field_221770_cu) {
            return 2000;
        }
        if (stack.func_77973_b() == Items.field_222047_ii) {
            return 162000;
        }
        if (stack.func_77973_b() == Items.field_221898_fg) {
            return 18000;
        }
        FreezerFuelTimeEvent event = new FreezerFuelTimeEvent(stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getFuelTime();
    }

    private boolean canFreeze(@Nullable IRecipe<?> recipe) {
        if (!((ItemStack)this.inventory.get(0)).func_190926_b() && recipe != null) {
            ItemStack outputStack = recipe.func_77571_b();
            if (outputStack.func_190926_b()) {
                return false;
            }
            ItemStack resultStack = (ItemStack)this.inventory.get(2);
            if (resultStack.func_190926_b()) {
                return true;
            }
            if (!resultStack.func_77969_a(outputStack)) {
                return false;
            }
            if (resultStack.func_190916_E() + outputStack.func_190916_E() <= this.func_70297_j_() && resultStack.func_190916_E() + outputStack.func_190916_E() <= resultStack.func_77976_d()) {
                return true;
            }
            return resultStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d();
        }
        return false;
    }

    private void freeze(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canFreeze(recipe)) {
            ItemStack sourceStack = (ItemStack)this.inventory.get(0);
            ItemStack outputStack = recipe.func_77571_b();
            ItemStack resultStack = (ItemStack)this.inventory.get(2);
            if (resultStack.func_190926_b()) {
                this.inventory.set(2, (Object)outputStack.func_77946_l());
            } else if (resultStack.func_77973_b() == outputStack.func_77973_b()) {
                resultStack.func_190917_f(outputStack.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.addRecipeUsed(recipe);
            }
            sourceStack.func_190918_g(1);
        }
    }

    @Override
    public int func_70302_i_() {
        return 3;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean sameItem;
        super.func_70299_a(index, stack);
        ItemStack slotStack = (ItemStack)this.inventory.get(index);
        boolean bl = sameItem = !stack.func_190926_b() && stack.func_77969_a(slotStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack);
        if (index == 0 && !sameItem) {
            this.freezeTimeTotal = this.getFreezeTime();
            this.freezeTime = 0;
            this.func_70296_d();
        }
    }

    protected int getFreezeTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(RecipeType.FREEZER_SOLIDIFY, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(300);
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cfm.freezer");
    }

    @Override
    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new FreezerContainer(windowId, playerInventory, this);
    }

    @Override
    public int[] func_180463_a(Direction direction) {
        switch (direction) {
            case UP: {
                return SLOTS_SOURCE;
            }
            case DOWN: {
                return SLOTS_RESULT;
            }
        }
        return SLOTS_FUEL;
    }

    private void addRecipeUsed(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.usedRecipeCount.compute(recipe.func_199560_c(), (id, count) -> 1 + (count == null ? 0 : count));
        }
    }

    public void spawnExperience(PlayerEntity player) {
        for (Map.Entry<ResourceLocation, Integer> entry : this.usedRecipeCount.entrySet()) {
            player.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(recipe -> FreezerTileEntity.spawnExperienceOrbs(player, (Integer)entry.getValue(), ((AbstractCookingRecipe)recipe).func_222138_b()));
        }
        this.usedRecipeCount.clear();
    }

    private static void spawnExperienceOrbs(PlayerEntity player, int count, float exp) {
        if (exp == 0.0f) {
            count = 0;
        } else if (exp < 1.0f) {
            int totalExp = MathHelper.func_76141_d((float)((float)count * exp));
            if (totalExp < MathHelper.func_76123_f((float)((float)count * exp)) && Math.random() < (double)((float)count * exp - (float)totalExp)) {
                ++totalExp;
            }
            count = totalExp;
        }
        while (count > 0) {
            int splitExp = ExperienceOrbEntity.func_70527_a((int)count);
            count -= splitExp;
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), splitExp));
        }
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        return this.getFreezeTime(stack) > 0;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.freezeTime = compound.func_74762_e("FreezeTime");
        this.freezeTimeTotal = compound.func_74762_e("FreezeTimeTotal");
        this.fuelTime = compound.func_74762_e("FuelTime");
        this.fuelTimeTotal = this.getFreezeTime((ItemStack)this.inventory.get(1));
        int recipesUsedSize = compound.func_74765_d("RecipesUsedSize");
        for (int i = 0; i < recipesUsedSize; ++i) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.func_74779_i("RecipeLocation" + i));
            int amount = compound.func_74762_e("RecipeAmount" + i);
            this.usedRecipeCount.put(resourcelocation, amount);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("FreezeTime", this.freezeTime);
        compound.func_74768_a("FreezeTimeTotal", this.freezeTimeTotal);
        compound.func_74768_a("FuelTime", this.fuelTime);
        compound.func_74777_a("RecipesUsedSize", (short)this.usedRecipeCount.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.usedRecipeCount.entrySet()) {
            compound.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            compound.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return compound;
    }

    public IIntArray getFreezerData() {
        return this.freezerData;
    }

    public void func_174889_b(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            if (this.playerCount < 0) {
                this.playerCount = 0;
            }
            ++this.playerCount;
            BlockState blockState = this.func_195044_w();
            boolean open = (Boolean)blockState.func_177229_b((Property)FreezerBlock.OPEN);
            if (!open) {
                this.playDoorSound(blockState, ModSounds.BLOCK_FRIDGE_OPEN);
                this.setDoorState(blockState, true);
            }
            this.scheduleTick();
        }
    }

    public void func_174886_c(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            --this.playerCount;
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void onScheduledTick() {
        World world = this.func_145831_w();
        if (world != null) {
            this.updatePlayerCount();
            if (this.playerCount > 0) {
                this.scheduleTick();
            } else {
                BlockState blockState = this.func_195044_w();
                if (!(blockState.func_177230_c() instanceof FreezerBlock)) {
                    this.func_145843_s();
                    return;
                }
                boolean open = (Boolean)blockState.func_177229_b((Property)FreezerBlock.OPEN);
                if (open) {
                    this.playDoorSound(blockState, ModSounds.BLOCK_FRIDGE_CLOSE);
                    this.setDoorState(blockState, false);
                }
            }
        }
    }

    private void playDoorSound(BlockState blockState, SoundEvent soundEvent) {
        Vector3i directionVec = ((Direction)blockState.func_177229_b((Property)FreezerBlock.DIRECTION)).func_176734_d().func_176730_m();
        double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)directionVec.func_177958_n() / 2.0;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)directionVec.func_177956_o() / 2.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)directionVec.func_177952_p() / 2.0;
        World world = this.func_145831_w();
        if (world != null) {
            world.func_184148_a(null, x, y, z, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void setDoorState(BlockState blockState, boolean open) {
        World world = this.func_145831_w();
        if (world != null) {
            world.func_180501_a(this.func_174877_v(), (BlockState)blockState.func_206870_a((Property)FreezerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    public void updatePlayerCount() {
        int count = 0;
        float radius = 5.0f;
        for (PlayerEntity playerentity : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - radius), (double)((float)this.field_174879_c.func_177956_o() - radius), (double)((float)this.field_174879_c.func_177952_p() - radius), (double)((float)(this.field_174879_c.func_177958_n() + 1) + radius), (double)((float)(this.field_174879_c.func_177956_o() + 1) + radius), (double)((float)(this.field_174879_c.func_177952_p() + 1) + radius)))) {
            if (!(playerentity.field_71070_bA instanceof FreezerContainer)) continue;
            ++count;
        }
        this.playerCount = count;
    }
}

