/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CookingRecipeSerializer<T extends AbstractCookingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;
    private final int fallbackCookTime;

    public CookingRecipeSerializer(IFactory<T> factory, int fallbackCookTime) {
        this.factory = factory;
        this.fallbackCookTime = fallbackCookTime;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonObject element = JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)element);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        ItemStack stack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.fallbackCookTime);
        return this.factory.create(recipeId, s, ingredient, stack, experience, cookTime);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack stack = buffer.func_150791_c();
        float experience = buffer.readFloat();
        int cookTime = buffer.func_150792_a();
        return this.factory.create(recipeId, group, ingredient, stack, experience, cookTime);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(buffer);
        buffer.func_150788_a(recipe.func_77571_b());
        buffer.writeFloat(recipe.func_222138_b());
        buffer.func_150787_b(recipe.func_222137_e());
    }

    public static interface IFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

