/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.common.mail;

import com.mrcrayfish.furniture.common.mail.Mail;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class MailBox
implements INBTSerializable<CompoundNBT> {
    private UUID id;
    private String name;
    private UUID ownerId;
    private String ownerName;
    private BlockPos pos;
    private RegistryKey<World> world = World.field_234918_g_;
    private List<Mail> mailStorage = new ArrayList<Mail>();

    public MailBox(UUID id, String name, UUID ownerId, String ownerName, BlockPos pos, RegistryKey<World> world) {
        this.id = id;
        this.name = name;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.pos = pos;
        this.world = world;
    }

    public MailBox(CompoundNBT compound) {
        this.deserializeNBT(compound);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public RegistryKey<World> getWorld() {
        return this.world;
    }

    public void addMail(Mail mail) {
        this.mailStorage.add(mail);
    }

    public List<Mail> getMailStorage() {
        return this.mailStorage;
    }

    public int getMailCount() {
        return this.mailStorage.size();
    }

    public CompoundNBT serializeDetails() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_186854_a("MailBoxUUID", this.id);
        compound.func_74778_a("MailBoxName", this.name);
        compound.func_186854_a("OwnerUUID", this.ownerId);
        compound.func_74778_a("OwnerName", this.ownerName);
        return compound;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_186854_a("MailBoxUUID", this.id);
        compound.func_74778_a("MailBoxName", this.name);
        compound.func_186854_a("OwnerUUID", this.ownerId);
        compound.func_74778_a("OwnerName", this.ownerName);
        compound.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        compound.func_74778_a("World", this.world.func_240901_a_().toString());
        if (!this.mailStorage.isEmpty()) {
            ListNBT mailStorageList = new ListNBT();
            this.mailStorage.forEach(mail -> mailStorageList.add((Object)mail.serializeNBT()));
            compound.func_218657_a("MailStorage", (INBT)mailStorageList);
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.mailStorage = new ArrayList<Mail>();
        this.id = compound.func_186857_a("MailBoxUUID");
        this.name = compound.func_74779_i("MailBoxName");
        this.ownerId = compound.func_186857_a("OwnerUUID");
        this.ownerName = compound.func_74779_i("OwnerName");
        this.pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Pos"));
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("World")));
        if (compound.func_150297_b("MailStorage", 9)) {
            ListNBT mailStorageList = compound.func_150295_c("MailStorage", 10);
            mailStorageList.forEach(nbt2 -> {
                CompoundNBT mailCompound = (CompoundNBT)nbt2;
                this.mailStorage.add(new Mail(mailCompound));
            });
        }
    }
}

