/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.gui.widget.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.furniture.client.event.CreativeScreenEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class TagButton
extends Button {
    private static final ResourceLocation TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private CreativeScreenEvents.TagFilter category;
    private ItemStack stack;
    private boolean toggled;

    public TagButton(int x, int y, CreativeScreenEvents.TagFilter category, Button.IPressable pressable) {
        super(x, y, 32, 28, ITextComponent.func_241827_a_((String)""), pressable);
        this.category = category;
        this.stack = category.getIcon();
        this.toggled = category.isEnabled();
    }

    public CreativeScreenEvents.TagFilter getCategory() {
        return this.category;
    }

    public void func_230930_b_() {
        this.toggled = !this.toggled;
        this.category.setEnabled(this.toggled);
        super.func_230930_b_();
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TABS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int width = this.toggled ? 32 : 28;
        int textureX = 28;
        int textureY = this.toggled ? 32 : 0;
        this.drawRotatedTexture(this.field_230690_l_, this.field_230691_m_, textureX, textureY, width, 28);
        RenderSystem.enableRescaleNormal();
        ItemRenderer renderer = mc.func_175599_af();
        renderer.field_77023_b = 100.0f;
        renderer.func_180450_b(this.stack, this.field_230690_l_ + 8, this.field_230691_m_ + 6);
        renderer.func_175030_a(mc.field_71466_p, this.stack, this.field_230690_l_ + 8, this.field_230691_m_ + 6);
        renderer.field_77023_b = 0.0f;
    }

    private void drawRotatedTexture(int x, int y, int textureX, int textureY, int width, int height) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_((float)(textureX + height) * scaleX, (float)textureY * scaleY).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((float)(textureX + height) * scaleX, (float)(textureY + width) * scaleY).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_((float)textureX * scaleX, (float)(textureY + width) * scaleY).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_((float)textureX * scaleX, (float)textureY * scaleY).func_181675_d();
        tessellator.func_78381_a();
    }

    public void updateState() {
        this.toggled = this.category.isEnabled();
    }
}

