/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.gui.screen.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.furniture.client.MailBoxEntry;
import com.mrcrayfish.furniture.client.gui.widget.button.IconButton;
import com.mrcrayfish.furniture.inventory.container.PostBoxContainer;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageRequestMailBoxes;
import com.mrcrayfish.furniture.network.message.MessageSendMail;
import com.mrcrayfish.furniture.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class PostBoxScreen
extends ContainerScreen<PostBoxContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("cfm", "textures/gui/container/post_box.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("cfm", "textures/gui/icons.png");
    private static final int LIST_WIDTH = 116;
    private static final int LIST_HEIGHT = 57;
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_HEIGHT = 15;
    private static final int ITEM_WIDTH = 116;
    private static final int ITEM_HEIGHT = 24;
    private static final int MAX_VISIBLE_ITEMS = (int)Math.ceil(2.375) + 1;
    private TextFieldWidget searchField;
    private int scroll;
    private int pressedMouseY = -1;
    private MailBoxEntry selected;
    private Button btnSend;
    private List<MailBoxEntry> mailBoxList = new ArrayList<MailBoxEntry>();
    private List<MailBoxEntry> filteredMailBoxList = new ArrayList<MailBoxEntry>();

    public PostBoxScreen(PostBoxContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147000_g = 187;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.searchField = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 22, this.field_147009_r + 19, 101, 9, ITextComponent.func_241827_a_((String)I18n.func_135052_a((String)"gui.cfm.post_box.search", (Object[])new Object[0])));
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(32);
        this.searchField.func_146193_g(0xFFFFFF);
        this.field_230705_e_.add(this.searchField);
        this.btnSend = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 147, this.field_147009_r + 53, I18n.func_135052_a((String)"gui.button.cfm.send_mail", (Object[])new Object[0]), this::sendMail, ICONS_TEXTURE, 32, 0));
        this.btnSend.field_230693_o_ = false;
        PacketHandler.instance.sendToServer((Object)new MessageRequestMailBoxes());
    }

    private void sendMail(Button button) {
        if (this.selected != null && !((PostBoxContainer)this.field_147002_h).getMail().func_190926_b()) {
            PacketHandler.instance.sendToServer((Object)new MessageSendMail(this.selected.getOwnerId(), this.selected.getMailBoxId()));
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.searchField.func_146178_a();
        this.btnSend.field_230693_o_ = this.selected != null && !((PostBoxContainer)this.field_147002_h).getMail().func_190926_b();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((PostBoxContainer)this.field_147002_h).getMail().func_190926_b()) {
            this.func_238474_b_(matrixStack, startX + 149, startY + 33, 116, 202, 16, 16);
        }
        this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        int startIndex;
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int scrollBarY = this.getScrollBarY(mouseY);
        int scrollBarUOffset = this.getMaxScroll() <= 0 ? 12 : 0;
        this.func_238474_b_(matrixStack, 128, 32 + scrollBarY, 116 + scrollBarUOffset, 187, 12, 15);
        GL11.glEnable((int)3089);
        RenderUtil.scissor(this.field_147003_i + 8, this.field_147009_r + 32, 116, 57);
        int scroll = this.scroll;
        if (this.pressedMouseY != -1) {
            scroll = (int)((double)this.getMaxScroll() * ((double)scrollBarY / 42.0) + 0.5);
        }
        for (int i = startIndex = scroll / 24; i < Math.min(startIndex + MAX_VISIBLE_ITEMS, this.filteredMailBoxList.size()); ++i) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)8.0f, (float)32.0f, (float)0.0f);
            RenderSystem.translatef((float)0.0f, (float)(-scroll), (float)0.0f);
            RenderSystem.translatef((float)0.0f, (float)(i * 24), (float)0.0f);
            MailBoxEntry entry = this.filteredMailBoxList.get(i);
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
            boolean isSelected = entry == this.selected;
            this.func_238474_b_(matrixStack, 0, 0, 0, 211 - (isSelected ? 24 : 0), 116, 24);
            if (isSelected) {
                this.func_238474_b_(matrixStack, 96, 5, 140, 187, 14, 12);
                this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.BOLD + entry.getName(), 3.0f, 3.0f, 0xFFFF55);
                this.field_230712_o_.func_238421_b_(matrixStack, entry.getOwnerName(), 3.0f, 13.0f, 0xFFFFFF);
            } else {
                this.field_230712_o_.func_238421_b_(matrixStack, entry.getName(), 3.0f, 3.0f, 0xFFFFFF);
                this.field_230712_o_.func_238421_b_(matrixStack, entry.getOwnerName(), 3.0f, 13.0f, 0x777777);
            }
            RenderSystem.popMatrix();
        }
        GL11.glDisable((int)3089);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (RenderUtil.isMouseInArea((int)mouseX, (int)mouseY, this.field_147003_i + 8, this.field_147009_r + 32, 116, 57) && (clickedIndex = (int)((mouseY - (double)this.field_147009_r - 32.0 + (double)this.scroll) / 24.0)) >= 0 && clickedIndex < this.filteredMailBoxList.size()) {
            MailBoxEntry entry = this.filteredMailBoxList.get(clickedIndex);
            this.selected = this.selected == entry ? null : entry;
            return true;
        }
        int scrollBarY = (int)(42.0 * ((double)this.scroll / (double)this.getMaxScroll()));
        if (this.getMaxScroll() > 0 && RenderUtil.isMouseInArea((int)mouseX, (int)mouseY, this.field_147003_i + 128, this.field_147009_r + 32 + scrollBarY, 12, 15)) {
            this.pressedMouseY = (int)mouseY;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.pressedMouseY != -1 && button == 0) {
            this.scroll = (int)((double)this.getMaxScroll() * ((double)this.getScrollBarY((int)mouseY) / 42.0) + 0.5);
            this.pressedMouseY = -1;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double speed) {
        if (RenderUtil.isMouseInArea((int)mouseX, (int)mouseY, this.field_147003_i + 8, this.field_147009_r + 32, 116, 57)) {
            this.scroll = (int)Math.max(0.0, Math.min((double)this.getMaxScroll(), (double)this.scroll - speed * 10.0));
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char c, int code) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.func_231042_a_(c, code)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.updateMailBoxList();
            }
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int key, int scanCode, int mods) {
        String s = this.searchField.func_146179_b();
        if (this.searchField.func_231046_a_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.func_146179_b())) {
                this.updateMailBoxList();
            }
            return true;
        }
        return this.searchField.func_230999_j_() && this.searchField.func_146176_q() && key != 256 || super.func_231046_a_(key, scanCode, mods);
    }

    private void updateMailBoxList() {
        if (this.searchField.func_146179_b().isEmpty()) {
            this.filteredMailBoxList = this.mailBoxList;
        } else {
            Stream<MailBoxEntry> stream = this.mailBoxList.stream().filter(entry -> {
                String searchText = this.searchField.func_146179_b().toLowerCase(Locale.ENGLISH).trim();
                if (entry.getName().toLowerCase().contains(searchText)) {
                    return true;
                }
                return entry.getOwnerName().toLowerCase().contains(searchText);
            });
            this.filteredMailBoxList = stream.collect(Collectors.toList());
        }
    }

    private int getScrollBarY(int mouseY) {
        int scrollOffset = 0;
        if (this.pressedMouseY != -1) {
            scrollOffset = mouseY - this.pressedMouseY;
        }
        int scrollBarY = (int)(42.0 * ((double)this.scroll / (double)this.getMaxScroll()));
        return MathHelper.func_76125_a((int)(scrollBarY + scrollOffset), (int)0, (int)42);
    }

    private int getMaxScroll() {
        return Math.max(0, 24 * this.filteredMailBoxList.size() - 57);
    }

    public void updateMailBoxes(List<MailBoxEntry> entries) {
        this.mailBoxList = entries;
        this.filteredMailBoxList = entries;
    }
}

