/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FridgeBlock;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.FreezerTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class FreezerBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();
    private final Block fridge;

    public FreezerBlock(AbstractBlock.Properties properties, Block fridge) {
        super(properties);
        this.fridge = fridge;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            Direction direction = (Direction)state1.func_177229_b((Property)DIRECTION);
            boolean open = (Boolean)state1.func_177229_b((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Block.func_208617_a((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0));
            if (open) {
                VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), Direction.SOUTH));
                VoxelShape[] DOOR = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)13.0, (double)1.0, (double)29.0, (double)16.0, (double)16.0, (double)13.0), Direction.SOUTH));
                shapes.add(BASE[direction.func_176736_b()]);
                shapes.add(DOOR[direction.func_176736_b()]);
            } else {
                shapes.add(Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
            }
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (((Direction)state.func_177229_b((Property)DIRECTION)).func_176734_d() == result.func_216354_b() && !world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof FreezerTileEntity) {
            ((FreezerTileEntity)tileEntity).onScheduledTick();
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FreezerTileEntity();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OPEN});
    }

    public boolean func_196260_a(BlockState state, IWorldReader reader, BlockPos pos) {
        return reader.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177984_a(), (BlockState)this.fridge.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)placer.func_174811_aO()));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        if (upState.func_177230_c() instanceof FridgeBlock) {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, pos.func_177984_a(), Block.func_196246_j((BlockState)upState));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }
}

