/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.IOException;
import java.io.OutputStream;

public interface ProgressCallback {
    public static final ProgressCallback TO_STD_OUT = new ProgressCallback(){

        @Override
        public void message(String message, MessagePriority priority) {
            System.out.println(message);
        }
    };

    default public void start(String label) {
        this.message(label);
    }

    default public void stage(String message) {
        this.message(message);
    }

    default public void message(String message) {
        this.message(message, MessagePriority.NORMAL);
    }

    public void message(String var1, MessagePriority var2);

    default public void progress(double progress) {
    }

    public static ProgressCallback withOutputs(final OutputStream ... streams) {
        return new ProgressCallback(){

            @Override
            public void message(String message, MessagePriority priority) {
                message = message + System.lineSeparator();
                for (OutputStream out : streams) {
                    try {
                        out.write(message.getBytes());
                        out.flush();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static enum MessagePriority {
        LOW,
        NORMAL,
        HIGH;

    }
}

