/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.BackpackItemHandler;
import com.flanks255.simplybackpacks.SBContainerSlot;
import com.flanks255.simplybackpacks.items.ItemBackpackBase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SBContainer
extends Container {
    public int slotcount = 0;
    private int slotID;
    public String itemKey = "";
    public static final ContainerType type = (ContainerType)new ContainerType(SBContainer::new).setRegistryName("sb_container");
    private PlayerInventory playerInv;
    public BackpackItemHandler handler;

    public SBContainer(int windowId, PlayerInventory playerInventory) {
        this(windowId, playerInventory.field_70458_d.field_70170_p, playerInventory.field_70458_d.func_233580_cy_(), playerInventory, playerInventory.field_70458_d);
    }

    public SBContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        super(type, windowId);
        this.playerInv = playerInventory;
        ItemStack stack = this.findBackpack(playerEntity);
        if (stack == null || stack.func_190926_b()) {
            playerEntity.func_71053_j();
            return;
        }
        IItemHandler tmp = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (tmp instanceof BackpackItemHandler) {
            this.handler = (BackpackItemHandler)tmp;
            this.handler.load();
            this.slotcount = tmp.getSlots();
            this.itemKey = stack.func_77977_a();
            this.addMySlots(stack);
            this.addPlayerSlots(this.playerInv);
        } else {
            playerEntity.func_71053_j();
        }
    }

    public SBContainer(int openType, int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        this(windowId, world, pos, playerInventory, playerEntity);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.slotID == -106) {
            return true;
        }
        return !playerIn.field_71071_by.func_70301_a(this.slotID).func_190926_b();
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slot >= 0 && this.func_75139_a(slot).func_75211_c().func_77973_b() instanceof ItemBackpackBase) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        if (slot >= 0) {
            this.func_75139_a((int)slot).field_75224_c.func_70296_d();
        }
        return super.func_184996_a(slot, dragType, clickTypeIn, player);
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        int originX = 0;
        int originY = 0;
        switch (this.slotcount) {
            case 18: {
                originX = 7;
                originY = 67;
                break;
            }
            case 33: {
                originX = 25;
                originY = 85;
                break;
            }
            case 66: {
                originX = 25;
                originY = 139;
                break;
            }
            default: {
                originX = 25;
                originY = 193;
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                int index = col + row * 9 + 9;
                this.func_75146_a(new Slot((IInventory)playerInventory, index, x + 1, y + 1));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            this.func_75146_a(new Slot((IInventory)playerInventory, col, x + 1, y + 1));
        }
    }

    private void addMySlots(ItemStack stack) {
        if (this.handler == null) {
            return;
        }
        int cols = this.slotcount == 18 ? 9 : 11;
        int rows = this.slotcount / cols;
        int slotindex = 0;
        block0: for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = 7 + col * 18;
                int y = 17 + row * 18;
                this.func_75146_a((Slot)new SBContainerSlot((IItemHandler)this.handler, slotindex, x + 1, y + 1));
                if (++slotindex >= this.slotcount) continue block0;
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int bagslotcount = this.field_75151_b.size() - playerIn.field_71071_by.field_70462_a.size();
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < bagslotcount ? !this.func_75135_a(itemstack1, bagslotcount, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, bagslotcount, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    private ItemStack findBackpack(PlayerEntity playerEntity) {
        PlayerInventory inv = playerEntity.field_71071_by;
        if (playerEntity.func_184614_ca().func_77973_b() instanceof ItemBackpackBase) {
            for (int i = 0; i <= 35; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack != playerEntity.func_184614_ca()) continue;
                this.slotID = i;
                return stack;
            }
        } else {
            if (playerEntity.func_184592_cb().func_77973_b() instanceof ItemBackpackBase) {
                this.slotID = -106;
                return playerEntity.func_184592_cb();
            }
            for (int i = 0; i <= 35; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBackpackBase)) continue;
                this.slotID = i;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }
}

