/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.items.ItemBackpackBase;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CopyBackpackDataRecipe
extends ShapedRecipe {
    public CopyBackpackDataRecipe(ResourceLocation id, String group, int recipeWidth, int recipeHeight, NonNullList<Ingredient> ingredients, ItemStack recipeOutput) {
        super(id, group, recipeWidth, recipeHeight, ingredients, recipeOutput);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack craftingResult = super.func_77572_b(inv);
        ItemStack dataSource = ItemStack.field_190927_a;
        if (!craftingResult.func_190926_b()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack item = inv.func_70301_a(i);
                if (item.func_190926_b() || !(item.func_77973_b() instanceof ItemBackpackBase)) continue;
                dataSource = item;
                break;
            }
            if (!dataSource.func_190926_b() && dataSource.func_77942_o()) {
                craftingResult.func_77982_d(dataSource.func_77978_p().func_74737_b());
            }
        }
        return craftingResult;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CopyBackpackDataRecipe> {
        private static final Method deserializeKey = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192408_a", (Class[])new Class[]{JsonObject.class});
        private static final Method shrink = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_194134_a", (Class[])new Class[]{String[].class});
        private static final Method patternFromJson = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192407_a", (Class[])new Class[]{JsonArray.class});
        private static final Method deserializeIngredients = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192402_a", (Class[])new Class[]{String[].class, Map.class, Integer.TYPE, Integer.TYPE});

        @Nullable
        public CopyBackpackDataRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.func_218666_n();
            NonNullList ingredients = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack craftingResult = buffer.func_150791_c();
            return new CopyBackpackDataRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, craftingResult);
        }

        public CopyBackpackDataRecipe read(ResourceLocation recipeId, JsonObject json) {
            try {
                String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
                Map map = (Map)deserializeKey.invoke(null, JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
                String[] pattern = (String[])shrink.invoke(null, patternFromJson.invoke(null, JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
                int width = pattern[0].length();
                int height = pattern.length;
                NonNullList ingredients = (NonNullList)deserializeIngredients.invoke(null, pattern, map, width, height);
                ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
                return new CopyBackpackDataRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)ingredients, result);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to parse backpack upgrade recipe");
            }
        }

        public void write(PacketBuffer buffer, CopyBackpackDataRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

