/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.Focus;
import mezz.jei.ingredients.IngredientInformation;
import mezz.jei.recipes.RecipeCategoryData;
import mezz.jei.recipes.RecipeCategoryDataMap;
import mezz.jei.recipes.RecipeManager;
import mezz.jei.recipes.RecipeMap;
import net.minecraft.util.ResourceLocation;

public class InternalRecipeManagerPlugin
implements IRecipeManagerPlugin {
    private final RecipeManager recipeManager;
    private final ImmutableMultimap<String, ResourceLocation> categoriesForRecipeCatalystKeys;
    private final IIngredientManager ingredientManager;
    private final RecipeCategoryDataMap recipeCategoriesMap;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;

    public InternalRecipeManagerPlugin(RecipeManager recipeManager, ImmutableMultimap<String, ResourceLocation> categoriesForRecipeCatalystKeys, IIngredientManager ingredientManager, RecipeCategoryDataMap recipeCategoriesMap, RecipeMap recipeInputMap, RecipeMap recipeOutputMap) {
        this.recipeManager = recipeManager;
        this.categoriesForRecipeCatalystKeys = categoriesForRecipeCatalystKeys;
        this.ingredientManager = ingredientManager;
        this.recipeCategoriesMap = recipeCategoriesMap;
        this.recipeInputMap = recipeInputMap;
        this.recipeOutputMap = recipeOutputMap;
    }

    @Override
    public <V> List<ResourceLocation> getRecipeCategoryUids(IFocus<V> focus) {
        focus = Focus.check(focus);
        V ingredient = focus.getValue();
        switch (focus.getMode()) {
            case INPUT: {
                return this.recipeInputMap.getRecipeCategories(ingredient);
            }
            case OUTPUT: {
                return this.recipeOutputMap.getRecipeCategories(ingredient);
            }
        }
        return this.getRecipeCategories();
    }

    private ImmutableList<ResourceLocation> getRecipeCategories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IRecipeCategory<?> recipeCategory : this.recipeManager.getRecipeCategories()) {
            builder.add((Object)recipeCategory.getUid());
        }
        return builder.build();
    }

    @Override
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        focus = Focus.check(focus);
        V ingredient = focus.getValue();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        if (focus.getMode() == IFocus.Mode.INPUT) {
            ImmutableList<T> recipes = this.recipeInputMap.getRecipes(recipeCategory, ingredient);
            ResourceLocation recipeCategoryUid = recipeCategory.getUid();
            for (String inputKey : IngredientInformation.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
                if (!this.categoriesForRecipeCatalystKeys.get((Object)inputKey).contains((Object)recipeCategoryUid)) continue;
                ImmutableSet specificRecipes = ImmutableSet.copyOf(recipes);
                RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesMap.get(recipeCategory);
                List<T> recipesForCategory = recipeCategoryData.getRecipes();
                ArrayList<T> allRecipes = new ArrayList<T>(recipes);
                for (T recipe : recipesForCategory) {
                    if (specificRecipes.contains(recipe)) continue;
                    allRecipes.add(recipe);
                }
                return allRecipes;
            }
            return recipes;
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, ingredient);
    }

    @Override
    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesMap.get(recipeCategory);
        List<T> recipes = recipeCategoryData.getRecipes();
        return Collections.unmodifiableList(recipes);
    }
}

