/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.textures.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigButton
extends GuiIconToggleButton {
    private final IngredientListOverlay parent;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(IngredientListOverlay parent, IWorldConfig worldConfig) {
        Textures textures = Internal.getTextures();
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), parent, worldConfig);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, IngredientListOverlay parent, IWorldConfig worldConfig) {
        super(disabledIcon, enabledIcon);
        this.parent = parent;
        this.worldConfig = worldConfig;
    }

    @Override
    protected void getTooltips(List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            TranslationTextComponent disabled = new TranslationTextComponent("jei.tooltip.ingredient.list.disabled");
            TranslationTextComponent overLay = new TranslationTextComponent(KeyBindings.toggleOverlay.func_197982_m());
            TranslationTextComponent disabledFix = new TranslationTextComponent("jei.tooltip.ingredient.list.disabled.how.to.fix", new Object[]{overLay});
            tooltip.add((ITextComponent)disabled.func_240699_a_(TextFormatting.GOLD));
            tooltip.add((ITextComponent)disabledFix.func_240699_a_(TextFormatting.GOLD));
        } else if (!this.parent.isListDisplayed()) {
            TranslationTextComponent notEnoughSpace = new TranslationTextComponent("jei.tooltip.not.enough.space");
            tooltip.add((ITextComponent)notEnoughSpace.func_240699_a_(TextFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            TranslationTextComponent enabled = new TranslationTextComponent("jei.tooltip.cheat.mode.button.enabled");
            tooltip.add((ITextComponent)enabled.func_240699_a_(TextFormatting.RED));
            KeyBinding toggleCheatMode = KeyBindings.toggleCheatMode;
            if (toggleCheatMode.getKey().func_197937_c() != 0) {
                TranslationTextComponent cheatMode = new TranslationTextComponent(toggleCheatMode.func_197982_m());
                TranslationTextComponent disableHotkey = new TranslationTextComponent("jei.tooltip.cheat.mode.how.to.disable.hotkey", new Object[]{cheatMode});
                tooltip.add((ITextComponent)disableHotkey.func_240699_a_(TextFormatting.RED));
            } else {
                TranslationTextComponent controlKeyLocalization = new TranslationTextComponent(Minecraft.field_142025_a ? "key.jei.ctrl.mac" : "key.jei.ctrl");
                TranslationTextComponent noHotKey = new TranslationTextComponent("jei.tooltip.cheat.mode.how.to.disable.no.hotkey", new Object[]{controlKeyLocalization});
                tooltip.add((ITextComponent)noHotKey.func_240699_a_(TextFormatting.RED));
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.worldConfig.isOverlayEnabled()) {
            long windowHandle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
            if (InputMappings.func_216506_a((long)windowHandle, (int)341) || InputMappings.func_216506_a((long)windowHandle, (int)345)) {
                this.worldConfig.toggleCheatItemsEnabled();
            } else {
                Minecraft minecraft = Minecraft.func_71410_x();
                if (minecraft.field_71462_r != null) {
                    // empty if block
                }
            }
            return true;
        }
        return false;
    }
}

