/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.util.MathUtil;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Container;

public class GuiContainerHandlers {
    private final List<Entry<?>> entries = new ArrayList();

    public <T extends ContainerScreen<?>> void add(Class<? extends T> containerClass, IGuiContainerHandler<T> handler) {
        Entry<T> entryForClass = this.getEntryForClass(containerClass);
        if (entryForClass == null) {
            entryForClass = new Entry(containerClass);
            this.entries.add(entryForClass);
        }
        entryForClass.addHandler(handler);
    }

    @Nullable
    private <T extends ContainerScreen<?>> Entry<T> getEntryForClass(Class<? extends T> containerClass) {
        return this.entries.stream().filter(entry -> ((Entry)entry).containerClass == containerClass).map(entry -> entry).findFirst().orElse(null);
    }

    private <T extends ContainerScreen<?>> Stream<Entry<? super T>> getEntriesForInstance(T containerScreen) {
        return this.entries.stream().filter(entry -> ((Entry)entry).containerClass.isInstance(containerScreen)).map(entry -> entry);
    }

    public <T extends ContainerScreen<?>> List<IGuiContainerHandler<? super T>> getActiveGuiHandlers(T guiContainer) {
        return this.getActiveGuiHandlerStream(guiContainer).collect(Collectors.toList());
    }

    public <T extends ContainerScreen<?>> Stream<IGuiContainerHandler<? super T>> getActiveGuiHandlerStream(T guiContainer) {
        return this.getEntriesForInstance(guiContainer).flatMap(entry -> entry.getHandlers().stream());
    }

    @Nullable
    public <T extends ContainerScreen<?>> IGuiClickableArea getGuiClickableArea(T guiContainer, double mouseX, double mouseY) {
        return this.getActiveGuiHandlerStream(guiContainer).flatMap(handler -> handler.getGuiClickableAreas(guiContainer, mouseX, mouseY).stream()).filter(guiClickableArea -> MathUtil.contains(guiClickableArea.getArea(), mouseX, mouseY)).findFirst().orElse(null);
    }

    public <C extends Container, T extends ContainerScreen<C>> Collection<Rectangle2d> getGuiExtraAreas(T guiContainer) {
        return this.getActiveGuiHandlerStream(guiContainer).flatMap(guiContainerHandler -> guiContainerHandler.getGuiExtraAreas(guiContainer).stream()).collect(Collectors.toList());
    }

    private static class Entry<T extends ContainerScreen<?>> {
        private final Class<? extends T> containerClass;
        private final List<IGuiContainerHandler<T>> handlers;

        private Entry(Class<? extends T> containerClass) {
            this.containerClass = containerClass;
            this.handlers = new ArrayList<IGuiContainerHandler<T>>();
        }

        public void addHandler(IGuiContainerHandler<T> handler) {
            this.handlers.add(handler);
        }

        public Class<? extends T> getContainerClass() {
            return this.containerClass;
        }

        public List<IGuiContainerHandler<T>> getHandlers() {
            return this.handlers;
        }
    }
}

